#include "mbed.h"
//#include "SharpDisplay.h"
#define TAG_ADDRESS_HIGH 0x20  //00100000b  //first transmit (high address)
#define TAG_ADDRESS_LOW  0x00 //00000000b  //second transmit (low address)
#define TAG_DATA_WRITE   0x40 //11000000b  //third transmit (data)
#define LCD_DATA_READ_FLAG 0x80  //this bit must be set when reading

#define LCD_SLEEP_OUT  0x11
#define LCD_DISPLAY_ON  0x29
#define LCD_ALLPON 0x23  //All pixels on
#define LCD_ALLPOFF 0x22 //All pixels off
#define LCD_RDDSDR 0x0F  //Results of self test


void SharpLCD_Init(void);
void SharpHeaderFileInit(void);
uint16_t SharpLCD_Write(uint16_t address, uint8_t data);
void SharpLCD_WriteAddress(uint16_t address);
uint8_t SharpLCD_Read(uint16_t address);
 
SPI device(D11, D12, SPI_SCK);

Serial pc(SERIAL_TX, SERIAL_RX);   //create a serial console
DigitalOut SharpReset(D8);  //set D8 as the reset output pin
DigitalOut SharpCS(D7);  //Set D7 as the cs output pin


 
int main() {
   wait_ms(200);  // I think the reset switch might bounce, so don't start right away.
   SharpCS = 1;  // 1= disable
   device.format(16,0);  //16 bits, mode 0 (default)
   device.frequency(500000);
   pc.baud(115200);   // set the serial port baud to 115.2k
   pc.printf("Sharp Spi Command Sender\n");
   
   //perform the reset ritual
   wait_ms(10);
   SharpReset = 1;
   SharpReset = 0;
   wait_ms(10);
   SharpReset = 1;
   wait_ms(200);
   
    
   //SharpLCD_Init();
   SharpHeaderFileInit();   //initialize with the method used in the sharp demo
   
 //  SharpLCD_WriteAddress((LCD_ALLPON<<8)&0xFF00);
//SharpLCD_WriteAddress((LCD_SLEEP_OUT<<8)&0xFF00);
//wait_ms(100);
//SharpLCD_WriteAddress((LCD_DISPLAY_ON<<8)&0xFF00);
//wait_ms(100);
 
  
    pc.printf("Read of address %x = %x\n", LCD_RDDSDR, SharpLCD_Read((LCD_RDDSDR<<8)&0xFF00));
    
    //after initialization, toggle the display white then black every second
    while(1){
          SharpLCD_WriteAddress((LCD_ALLPON<<8)&0xFF00);
          wait(1.0);   
          SharpLCD_WriteAddress((LCD_ALLPOFF<<8)&0xFF00);
          wait(1.0);
    }
}
 
 

    

void SharpLCD_WriteAddress(uint16_t address)
{
   SharpCS = 0;
   device.write((TAG_ADDRESS_HIGH<<8)  | (address>>8));
   SharpCS = 1;
   wait_us(10);

   SharpCS = 0;
   device.write((TAG_ADDRESS_LOW<<8) | (address & 0xFF));
   SharpCS = 1;
   wait_us(10);
    
    }

uint16_t SharpLCD_Write(uint16_t address, uint8_t data)
{
  uint16_t retval = 0;
  SharpLCD_WriteAddress(address);
  
   SharpCS = 0;
   retval  = device.write((TAG_DATA_WRITE <<8) | data);
   SharpCS = 1;
   wait_us(10);
 
  return retval;
    
}

uint8_t SharpLCD_Read(uint16_t address)
{
  uint8_t retval = 0;
  SharpLCD_WriteAddress(address);


   SharpCS = 0;
   retval  = (uint8_t) (0xFF && device.write((TAG_DATA_WRITE <<8)| (LCD_DATA_READ_FLAG<<8) | 0xFF));
   SharpCS = 1;
   wait_us(10);
 
  return retval;
    
}



    
void SharpLCD_Init(void)
{

    /*Configure LCD*/
SharpLCD_Write(0xFF00,0xAA);
SharpLCD_Write(0xFF01,0x55);
SharpLCD_Write(0xFF02,0x25);
SharpLCD_Write(0xFF03,0x01);
SharpLCD_Write(0xF300,0x00);
SharpLCD_Write(0xF301,0x32);
SharpLCD_Write(0xF302,0x00);
SharpLCD_Write(0xF303,0x38);
SharpLCD_Write(0xF304,0x31);
SharpLCD_Write(0xF305,0x08);
SharpLCD_Write(0xF306,0x11);
SharpLCD_Write(0xF307,0x00);
SharpLCD_Write(0xF000,0x55);
SharpLCD_Write(0xF001,0xAA);
SharpLCD_Write(0xF002,0x52);
SharpLCD_Write(0xF003,0x08);
SharpLCD_Write(0xF004,0x00);
SharpLCD_Write(0xB000,0x00);
SharpLCD_Write(0xB001,0x05);
SharpLCD_Write(0xB002,0x02);
SharpLCD_Write(0xB003,0x05);
SharpLCD_Write(0xB004,0x02);
SharpLCD_Write(0xB300,0x00);
SharpLCD_Write(0xB600,0x03);
SharpLCD_Write(0xB700,0x70);
SharpLCD_Write(0xB701,0x70);
SharpLCD_Write(0xB800,0x00);
SharpLCD_Write(0xB801,0x06);
SharpLCD_Write(0xB802,0x06);
SharpLCD_Write(0xB805,0x06);
SharpLCD_Write(0xBC00,0x00);
SharpLCD_Write(0xBC01,0xc8);
SharpLCD_Write(0xBC02,0x00);
SharpLCD_Write(0xBD00,0x01);
SharpLCD_Write(0xBD01,0x84);
SharpLCD_Write(0xBD02,0x06);
SharpLCD_Write(0xBD03,0x50);
SharpLCD_Write(0xBD04,0x00);
SharpLCD_Write(0xcc00,0x03);
SharpLCD_Write(0xcc01,0x01);
SharpLCD_Write(0xcc02,0x06);
SharpLCD_Write(0xF000,0x55);
SharpLCD_Write(0xF001,0xAA);
SharpLCD_Write(0xF002,0x52);
SharpLCD_Write(0xF003,0x08);
SharpLCD_Write(0xF004,0x01);
SharpLCD_Write(0xB000,0x05);
SharpLCD_Write(0xB001,0x05);
SharpLCD_Write(0xB002,0x05);
SharpLCD_Write(0xB100,0x05);
SharpLCD_Write(0xB101,0x05);
SharpLCD_Write(0xB102,0x05);
SharpLCD_Write(0xB200,0x03);
SharpLCD_Write(0xB201,0x03);
SharpLCD_Write(0xB202,0x03);
SharpLCD_Write(0xB800,0x25);
SharpLCD_Write(0xB801,0x25);
SharpLCD_Write(0xB802,0x25);
SharpLCD_Write(0xB300,0x0b);
SharpLCD_Write(0xB301,0x0b);
SharpLCD_Write(0xB302,0x0b);
SharpLCD_Write(0xB900,0x34);
SharpLCD_Write(0xB901,0x34);
SharpLCD_Write(0xB902,0x34);
SharpLCD_Write(0xBF00,0x01);
SharpLCD_Write(0xB500,0x08);
SharpLCD_Write(0xB501,0x08);
SharpLCD_Write(0xB502,0x08);
SharpLCD_Write(0xBA00,0x24);
SharpLCD_Write(0xBA01,0x24);
SharpLCD_Write(0xBA02,0x24);
SharpLCD_Write(0xB400,0x2D);
SharpLCD_Write(0xB401,0x2D);
SharpLCD_Write(0xB402,0x2D);
SharpLCD_Write(0xBC00,0x00);
SharpLCD_Write(0xBC01,0x68);
SharpLCD_Write(0xBC02,0x00);
SharpLCD_Write(0xBD00,0x00);
SharpLCD_Write(0xBD01,0x7C);
SharpLCD_Write(0xBD02,0x00);
SharpLCD_Write(0xBE00,0x00);
SharpLCD_Write(0xBE01,0x40);
SharpLCD_Write(0xF000,0x55);
SharpLCD_Write(0xF001,0xAA);
SharpLCD_Write(0xF002,0x52);
SharpLCD_Write(0xF003,0x01);
SharpLCD_Write(0xD000,0x0B);
SharpLCD_Write(0xD001,0x14);
SharpLCD_Write(0xD002,0x0C);
SharpLCD_Write(0xD003,0x0E);
SharpLCD_Write(0xD100,0x00);
SharpLCD_Write(0xD101,0x37);
SharpLCD_Write(0xD102,0x00);
SharpLCD_Write(0xD103,0x4A);
SharpLCD_Write(0xD104,0x00);
SharpLCD_Write(0xD105,0x6F);
SharpLCD_Write(0xD106,0x00);
SharpLCD_Write(0xD107,0x8D);
SharpLCD_Write(0xD108,0x00);
SharpLCD_Write(0xD109,0xAD);
SharpLCD_Write(0xD10A,0x00);
SharpLCD_Write(0xD10B,0xDF);
SharpLCD_Write(0xD10C,0x01);
SharpLCD_Write(0xD10D,0x11);
SharpLCD_Write(0xD10E,0x01);
SharpLCD_Write(0xD10F,0x58);
SharpLCD_Write(0xD110,0x01);
SharpLCD_Write(0xD111,0x76);
SharpLCD_Write(0xD112,0x01);
SharpLCD_Write(0xD113,0xA6);
SharpLCD_Write(0xD114,0x01);
SharpLCD_Write(0xD115,0xCD);
SharpLCD_Write(0xD116,0x02);
SharpLCD_Write(0xD117,0x0E);
SharpLCD_Write(0xD118,0x02);
SharpLCD_Write(0xD119,0x46);
SharpLCD_Write(0xD11A,0x02);
SharpLCD_Write(0xD11B,0x48);
SharpLCD_Write(0xD11C,0x02);
SharpLCD_Write(0xD11D,0x78);
SharpLCD_Write(0xD11E,0x02);
SharpLCD_Write(0xD11F,0xAC);
SharpLCD_Write(0xD120,0x02);
SharpLCD_Write(0xD121,0xCD);
SharpLCD_Write(0xD122,0x02);
SharpLCD_Write(0xD123,0xFD);
SharpLCD_Write(0xD124,0x03);
SharpLCD_Write(0xD125,0x1F);
SharpLCD_Write(0xD126,0x03);
SharpLCD_Write(0xD127,0x4B);
SharpLCD_Write(0xD128,0x03);
SharpLCD_Write(0xD129,0x69);
SharpLCD_Write(0xD12A,0x03);
SharpLCD_Write(0xD12B,0x8E);
SharpLCD_Write(0xD12C,0x03);
SharpLCD_Write(0xD12D,0xA5);
SharpLCD_Write(0xD12E,0x03);
SharpLCD_Write(0xD12F,0xCD);
SharpLCD_Write(0xD130,0x03);
SharpLCD_Write(0xD131,0xF1);
SharpLCD_Write(0xD132,0x03);
SharpLCD_Write(0xD133,0xF1);
SharpLCD_Write(0xD200,0x00);
SharpLCD_Write(0xD201,0x37);
SharpLCD_Write(0xD202,0x00);
SharpLCD_Write(0xD203,0x4A);
SharpLCD_Write(0xD204,0x00);
SharpLCD_Write(0xD205,0x6F);
SharpLCD_Write(0xD206,0x00);
SharpLCD_Write(0xD207,0x8D);
SharpLCD_Write(0xD208,0x00);
SharpLCD_Write(0xD209,0xAD);
SharpLCD_Write(0xD20A,0x00);
SharpLCD_Write(0xD20B,0xDF);
SharpLCD_Write(0xD20C,0x01);
SharpLCD_Write(0xD20D,0x11);
SharpLCD_Write(0xD20E,0x01);
SharpLCD_Write(0xD20F,0x58);
SharpLCD_Write(0xD210,0x01);
SharpLCD_Write(0xD211,0x76);
SharpLCD_Write(0xD212,0x01);
SharpLCD_Write(0xD213,0xA6);
SharpLCD_Write(0xD214,0x01);
SharpLCD_Write(0xD215,0xCD);
SharpLCD_Write(0xD216,0x02);
SharpLCD_Write(0xD217,0x0E);
SharpLCD_Write(0xD218,0x02);
SharpLCD_Write(0xD219,0x46);
SharpLCD_Write(0xD21A,0x02);
SharpLCD_Write(0xD21B,0x48);
SharpLCD_Write(0xD21C,0x02);
SharpLCD_Write(0xD21D,0x78);
SharpLCD_Write(0xD21E,0x02);
SharpLCD_Write(0xD21F,0xAC);
SharpLCD_Write(0xD220,0x02);
SharpLCD_Write(0xD221,0xCD);
SharpLCD_Write(0xD222,0x02);
SharpLCD_Write(0xD223,0xFD);
SharpLCD_Write(0xD224,0x03);
SharpLCD_Write(0xD225,0x1F);
SharpLCD_Write(0xD226,0x03);
SharpLCD_Write(0xD227,0x4B);
SharpLCD_Write(0xD228,0x03);
SharpLCD_Write(0xD229,0x69);
SharpLCD_Write(0xD22A,0x03);
SharpLCD_Write(0xD22B,0x8E);
SharpLCD_Write(0xD22C,0x03);
SharpLCD_Write(0xD22D,0xA5);
SharpLCD_Write(0xD22E,0x03);
SharpLCD_Write(0xD22F,0xCD);
SharpLCD_Write(0xD230,0x03);
SharpLCD_Write(0xD231,0xF1);
SharpLCD_Write(0xD232,0x03);
SharpLCD_Write(0xD233,0xF1);
SharpLCD_Write(0xD300,0x00);
SharpLCD_Write(0xD301,0x37);
SharpLCD_Write(0xD302,0x00);
SharpLCD_Write(0xD303,0x4A);
SharpLCD_Write(0xD304,0x00);
SharpLCD_Write(0xD305,0x6F);
SharpLCD_Write(0xD306,0x00);
SharpLCD_Write(0xD307,0x8D);
SharpLCD_Write(0xD308,0x00);
SharpLCD_Write(0xD309,0xAD);
SharpLCD_Write(0xD30A,0x00);
SharpLCD_Write(0xD30B,0xDF);
SharpLCD_Write(0xD30C,0x01);
SharpLCD_Write(0xD30D,0x11);
SharpLCD_Write(0xD30E,0x01);
SharpLCD_Write(0xD30F,0x58);
SharpLCD_Write(0xD310,0x01);
SharpLCD_Write(0xD311,0x76);
SharpLCD_Write(0xD312,0x01);
SharpLCD_Write(0xD313,0xA6);
SharpLCD_Write(0xD314,0x01);
SharpLCD_Write(0xD315,0xCD);
SharpLCD_Write(0xD316,0x02);
SharpLCD_Write(0xD317,0x0E);
SharpLCD_Write(0xD318,0x02);
SharpLCD_Write(0xD319,0x46);
SharpLCD_Write(0xD31A,0x02);
SharpLCD_Write(0xD31B,0x48);
SharpLCD_Write(0xD31C,0x02);
SharpLCD_Write(0xD31D,0x78);
SharpLCD_Write(0xD31E,0x02);
SharpLCD_Write(0xD31F,0xAC);
SharpLCD_Write(0xD320,0x02);
SharpLCD_Write(0xD321,0xCD);
SharpLCD_Write(0xD322,0x02);
SharpLCD_Write(0xD323,0xFD);
SharpLCD_Write(0xD324,0x03);
SharpLCD_Write(0xD325,0x1F);
SharpLCD_Write(0xD326,0x03);
SharpLCD_Write(0xD327,0x4B);
SharpLCD_Write(0xD328,0x03);
SharpLCD_Write(0xD329,0x69);
SharpLCD_Write(0xD32A,0x03);
SharpLCD_Write(0xD32B,0x8E);
SharpLCD_Write(0xD32C,0x03);
SharpLCD_Write(0xD32D,0xA5);
SharpLCD_Write(0xD32E,0x03);
SharpLCD_Write(0xD32F,0xCD);
SharpLCD_Write(0xD330,0x03);
SharpLCD_Write(0xD331,0xF1);
SharpLCD_Write(0xD332,0x03);
SharpLCD_Write(0xD333,0xF1);
SharpLCD_Write(0xD400,0x00);
SharpLCD_Write(0xD401,0x37);
SharpLCD_Write(0xD402,0x00);
SharpLCD_Write(0xD403,0x4A);
SharpLCD_Write(0xD404,0x00);
SharpLCD_Write(0xD405,0x6F);
SharpLCD_Write(0xD406,0x00);
SharpLCD_Write(0xD407,0x8D);
SharpLCD_Write(0xD408,0x00);
SharpLCD_Write(0xD409,0xAD);
SharpLCD_Write(0xD40A,0x00);
SharpLCD_Write(0xD40B,0xDF);
SharpLCD_Write(0xD40C,0x01);
SharpLCD_Write(0xD40D,0x11);
SharpLCD_Write(0xD40E,0x01);
SharpLCD_Write(0xD40F,0x58);
SharpLCD_Write(0xD410,0x01);
SharpLCD_Write(0xD411,0x76);
SharpLCD_Write(0xD412,0x01);
SharpLCD_Write(0xD413,0xA6);
SharpLCD_Write(0xD414,0x01);
SharpLCD_Write(0xD415,0xCD);
SharpLCD_Write(0xD416,0x02);
SharpLCD_Write(0xD417,0x0E);
SharpLCD_Write(0xD418,0x02);
SharpLCD_Write(0xD419,0x46);
SharpLCD_Write(0xD41A,0x02);
SharpLCD_Write(0xD41B,0x48);
SharpLCD_Write(0xD41C,0x02);
SharpLCD_Write(0xD41D,0x78);
SharpLCD_Write(0xD41E,0x02);
SharpLCD_Write(0xD41F,0xAC);
SharpLCD_Write(0xD420,0x02);
SharpLCD_Write(0xD421,0xCD);
SharpLCD_Write(0xD422,0x02);
SharpLCD_Write(0xD423,0xFD);
SharpLCD_Write(0xD424,0x03);
SharpLCD_Write(0xD425,0x1F);
SharpLCD_Write(0xD426,0x03);
SharpLCD_Write(0xD427,0x4B);
SharpLCD_Write(0xD428,0x03);
SharpLCD_Write(0xD429,0x69);
SharpLCD_Write(0xD42A,0x03);
SharpLCD_Write(0xD42B,0x8E);
SharpLCD_Write(0xD42C,0x03);
SharpLCD_Write(0xD42D,0xA5);
SharpLCD_Write(0xD42E,0x03);
SharpLCD_Write(0xD42F,0xCD);
SharpLCD_Write(0xD430,0x03);
SharpLCD_Write(0xD431,0xF1);
SharpLCD_Write(0xD432,0x03);
SharpLCD_Write(0xD433,0xF1);
SharpLCD_Write(0xD500,0x00);
SharpLCD_Write(0xD501,0x37);
SharpLCD_Write(0xD502,0x00);
SharpLCD_Write(0xD503,0x4A);
SharpLCD_Write(0xD504,0x00);
SharpLCD_Write(0xD505,0x6F);
SharpLCD_Write(0xD506,0x00);
SharpLCD_Write(0xD507,0x8D);
SharpLCD_Write(0xD508,0x00);
SharpLCD_Write(0xD509,0xAD);
SharpLCD_Write(0xD50A,0x00);
SharpLCD_Write(0xD50B,0xDF);
SharpLCD_Write(0xD50C,0x01);
SharpLCD_Write(0xD50D,0x11);
SharpLCD_Write(0xD50E,0x01);
SharpLCD_Write(0xD50F,0x58);
SharpLCD_Write(0xD510,0x01);
SharpLCD_Write(0xD511,0x76);
SharpLCD_Write(0xD512,0x01);
SharpLCD_Write(0xD513,0xA6);
SharpLCD_Write(0xD514,0x01);
SharpLCD_Write(0xD515,0xCD);
SharpLCD_Write(0xD516,0x02);
SharpLCD_Write(0xD517,0x0E);
SharpLCD_Write(0xD518,0x02);
SharpLCD_Write(0xD519,0x46);
SharpLCD_Write(0xD51A,0x02);
SharpLCD_Write(0xD51B,0x48);
SharpLCD_Write(0xD51C,0x02);
SharpLCD_Write(0xD51D,0x78);
SharpLCD_Write(0xD51E,0x02);
SharpLCD_Write(0xD51F,0xAC);
SharpLCD_Write(0xD520,0x02);
SharpLCD_Write(0xD521,0xCD);
SharpLCD_Write(0xD522,0x02);
SharpLCD_Write(0xD523,0xFD);
SharpLCD_Write(0xD524,0x03);
SharpLCD_Write(0xD525,0x1F);
SharpLCD_Write(0xD526,0x03);
SharpLCD_Write(0xD527,0x4B);
SharpLCD_Write(0xD528,0x03);
SharpLCD_Write(0xD529,0x69);
SharpLCD_Write(0xD52A,0x03);
SharpLCD_Write(0xD52B,0x8E);
SharpLCD_Write(0xD52C,0x03);
SharpLCD_Write(0xD52D,0xA5);
SharpLCD_Write(0xD52E,0x03);
SharpLCD_Write(0xD52F,0xCD);
SharpLCD_Write(0xD530,0x03);
SharpLCD_Write(0xD531,0xF1);
SharpLCD_Write(0xD532,0x03);
SharpLCD_Write(0xD533,0xF1);
SharpLCD_Write(0xD600,0x00);
SharpLCD_Write(0xD601,0x37);
SharpLCD_Write(0xD602,0x00);
SharpLCD_Write(0xD603,0x4A);
SharpLCD_Write(0xD604,0x00);
SharpLCD_Write(0xD605,0x6F);
SharpLCD_Write(0xD606,0x00);
SharpLCD_Write(0xD607,0x8D);
SharpLCD_Write(0xD608,0x00);
SharpLCD_Write(0xD609,0xAD);
SharpLCD_Write(0xD60A,0x00);
SharpLCD_Write(0xD60B,0xDF);
SharpLCD_Write(0xD60C,0x01);
SharpLCD_Write(0xD60D,0x11);
SharpLCD_Write(0xD60E,0x01);
SharpLCD_Write(0xD60F,0x58);
SharpLCD_Write(0xD610,0x01);
SharpLCD_Write(0xD611,0x76);
SharpLCD_Write(0xD612,0x01);
SharpLCD_Write(0xD613,0xA6);
SharpLCD_Write(0xD614,0x01);
SharpLCD_Write(0xD615,0xCD);
SharpLCD_Write(0xD616,0x02);
SharpLCD_Write(0xD617,0x0E);
SharpLCD_Write(0xD618,0x02);
SharpLCD_Write(0xD619,0x46);
SharpLCD_Write(0xD61A,0x02);
SharpLCD_Write(0xD61B,0x48);
SharpLCD_Write(0xD61C,0x02);
SharpLCD_Write(0xD61D,0x78);
SharpLCD_Write(0xD61E,0x02);
SharpLCD_Write(0xD61F,0xAC);
SharpLCD_Write(0xD620,0x02);
SharpLCD_Write(0xD621,0xCD);
SharpLCD_Write(0xD622,0x02);
SharpLCD_Write(0xD623,0xFD);
SharpLCD_Write(0xD624,0x03);
SharpLCD_Write(0xD625,0x1F);
SharpLCD_Write(0xD626,0x03);
SharpLCD_Write(0xD627,0x4B);
SharpLCD_Write(0xD628,0x03);
SharpLCD_Write(0xD629,0x69);
SharpLCD_Write(0xD62A,0x03);
SharpLCD_Write(0xD62B,0x8E);
SharpLCD_Write(0xD62C,0x03);
SharpLCD_Write(0xD62D,0xA5);
SharpLCD_Write(0xD62E,0x03);
SharpLCD_Write(0xD62F,0xCD);
SharpLCD_Write(0xD630,0x03);
SharpLCD_Write(0xD631,0xF1);
SharpLCD_Write(0xD632,0x03);
SharpLCD_Write(0xD633,0xF1);
SharpLCD_Write(0xF000,0x55);
SharpLCD_Write(0xF001,0xAA);
SharpLCD_Write(0xF002,0x52);
SharpLCD_Write(0xF003,0x08);
SharpLCD_Write(0xF004,0x00);
SharpLCD_Write(0xB400,0x10);
SharpLCD_Write(0x3A00,0x77);
SharpLCD_Write(0xB101,0x00);
SharpLCD_WriteAddress((LCD_SLEEP_OUT<<8)&0xFF00);
wait_ms(100);
SharpLCD_WriteAddress((LCD_DISPLAY_ON<<8)&0xFF00);
wait_ms(100);
  
}



void SharpHeaderFileInit(void)   //this is the function version of the header I received from Scott Bradley
{
SharpLCD_Write(0xFF00, 0xAA);
SharpLCD_Write(0xFF01, 0x55);
SharpLCD_Write(0xFF02, 0x25);
SharpLCD_Write(0xFF03, 0x1);
SharpLCD_Write(0xF300, 0x0);
SharpLCD_Write(0xF301, 0x32);
SharpLCD_Write(0xF302, 0x0);
SharpLCD_Write(0xF303, 0x38);
SharpLCD_Write(0xF304, 0x31);
SharpLCD_Write(0xF305, 0x8);
SharpLCD_Write(0xF306, 0x11);
SharpLCD_Write(0xF307, 0x0);
SharpLCD_Write(0xF000, 0x55);
SharpLCD_Write(0xF001, 0xAA);
SharpLCD_Write(0xF002, 0x52);
SharpLCD_Write(0xF003, 0x8);
SharpLCD_Write(0xF004, 0x0);
SharpLCD_Write(0xB000, 0x0);
SharpLCD_Write(0xB001, 0x5);
SharpLCD_Write(0xB002, 0x2);
SharpLCD_Write(0xB003, 0x5);
SharpLCD_Write(0xB004, 0x2);
SharpLCD_Write(0xB300, 0x0);
SharpLCD_Write(0xB600, 0xA);
SharpLCD_Write(0xB700, 0x0);
SharpLCD_Write(0xB701, 0x0);
SharpLCD_Write(0xB800, 0x1);
SharpLCD_Write(0xB801, 0x5);
SharpLCD_Write(0xB802, 0x5);
SharpLCD_Write(0x803, 0x5);
SharpLCD_Write(0xBC00, 0x0);
SharpLCD_Write(0xBC01, 0xC8);
SharpLCD_Write(0xBC02, 0x0);
SharpLCD_Write(0xBD00, 0x1);
SharpLCD_Write(0xBD01, 0x84);
SharpLCD_Write(0xBD02, 0x6);
SharpLCD_Write(0xBD03, 0x50);
SharpLCD_Write(0xBD04, 0x0);
SharpLCD_Write(0xCC00, 0x3);
SharpLCD_Write(0xCC01, 0x0);
SharpLCD_Write(0xCC02, 0x0);
SharpLCD_Write(0xF000, 0x55);
SharpLCD_Write(0xF001, 0xAA);
SharpLCD_Write(0xF002, 0x52);
SharpLCD_Write(0xF003, 0x8);
SharpLCD_Write(0xF004, 0x1);
SharpLCD_Write(0xB000, 0x5);
SharpLCD_Write(0xB001, 0x5);
SharpLCD_Write(0xB002, 0x5);
SharpLCD_Write(0xB100, 0x5);
SharpLCD_Write(0xB101, 0x5);
SharpLCD_Write(0xB102, 0x5);
SharpLCD_Write(0xB200, 0x3);
SharpLCD_Write(0xB201, 0x3);
SharpLCD_Write(0xB202, 0x3);
SharpLCD_Write(0xB800, 0x25);
SharpLCD_Write(0xB801, 0x25);
SharpLCD_Write(0xB802, 0x25);
SharpLCD_Write(0xB300, 0x9);
SharpLCD_Write(0xB301, 0x9);
SharpLCD_Write(0xB302, 0x9);
SharpLCD_Write(0xB900, 0x34);
SharpLCD_Write(0xB901, 0x34);
SharpLCD_Write(0xB902, 0x34);
SharpLCD_Write(0xBF00, 0x1);
SharpLCD_Write(0xB500, 0xA);
SharpLCD_Write(0xB501, 0xA);
SharpLCD_Write(0xB502, 0xA);
SharpLCD_Write(0xBA00, 0x24);
SharpLCD_Write(0xBA01, 0x24);
SharpLCD_Write(0xBA02, 0x24);
SharpLCD_Write(0xB400, 0x2D);
SharpLCD_Write(0xB401, 0x2D);
SharpLCD_Write(0xB402, 0x2D);
SharpLCD_Write(0xBC00, 0x0);
SharpLCD_Write(0xBC01, 0x68);
SharpLCD_Write(0xBC02, 0x0);
SharpLCD_Write(0xBD00, 0x0);
SharpLCD_Write(0xBD01, 0x7C);
SharpLCD_Write(0xBD02, 0x0);
SharpLCD_Write(0xBE00, 0x0);
SharpLCD_Write(0xBE01, 0x70);
SharpLCD_Write(0xF000, 0x55);
SharpLCD_Write(0xF001, 0xAA);
SharpLCD_Write(0xF002, 0x52);
SharpLCD_Write(0xF003, 0x1);
SharpLCD_Write(0xD000, 0xB);
SharpLCD_Write(0xD001, 0x14);
SharpLCD_Write(0xD002, 0xC);
SharpLCD_Write(0xD003, 0xE);
SharpLCD_Write(0xD100, 0x0);
SharpLCD_Write(0xD101, 0x37);
SharpLCD_Write(0xD102, 0x0);
SharpLCD_Write(0xD103, 0x4A);
SharpLCD_Write(0xD104, 0x0);
SharpLCD_Write(0xD105, 0x6F);
SharpLCD_Write(0xD106, 0x0);
SharpLCD_Write(0xD107, 0x8D);
SharpLCD_Write(0xD108, 0x0);
SharpLCD_Write(0xD109, 0xAD);
SharpLCD_Write(0xD10A, 0x0);
SharpLCD_Write(0xD10B, 0xDF);
SharpLCD_Write(0xD10C, 0x1);
SharpLCD_Write(0xD10D, 0x11);
SharpLCD_Write(0xD10E, 0x1);
SharpLCD_Write(0xD10F, 0x58);
SharpLCD_Write(0xD110, 0x1);
SharpLCD_Write(0xD111, 0x76);
SharpLCD_Write(0xD112, 0x1);
SharpLCD_Write(0xD113, 0xA6);
SharpLCD_Write(0xD114, 0x1);
SharpLCD_Write(0xD115, 0xCD);
SharpLCD_Write(0xD116, 0x2);
SharpLCD_Write(0xD117, 0xE);
SharpLCD_Write(0xD118, 0x2);
SharpLCD_Write(0xD119, 0x46);
SharpLCD_Write(0xD11A, 0x2);
SharpLCD_Write(0xD11B, 0x48);
SharpLCD_Write(0xD11C, 0x2);
SharpLCD_Write(0xD11D, 0x78);
SharpLCD_Write(0xD11E, 0x2);
SharpLCD_Write(0xD11F, 0xAC);
SharpLCD_Write(0xD120, 0x2);
SharpLCD_Write(0xD121, 0xCD);
SharpLCD_Write(0xD122, 0x2);
SharpLCD_Write(0xD123, 0xFD);
SharpLCD_Write(0xD124, 0x3);
SharpLCD_Write(0xD125, 0x1F);
SharpLCD_Write(0xD126, 0x3);
SharpLCD_Write(0xD127, 0x4B);
SharpLCD_Write(0xD128, 0x3);
SharpLCD_Write(0xD129, 0x69);
SharpLCD_Write(0xD12A, 0x3);
SharpLCD_Write(0xD12B, 0x8E);
SharpLCD_Write(0xD12C, 0x3);
SharpLCD_Write(0xD12D, 0xA5);
SharpLCD_Write(0xD12E, 0x3);
SharpLCD_Write(0xD12F, 0xCD);
SharpLCD_Write(0xD130, 0x3);
SharpLCD_Write(0xD131, 0xF1);
SharpLCD_Write(0xD132, 0x3);
SharpLCD_Write(0xD133, 0xF1);
SharpLCD_Write(0xD200, 0x0);
SharpLCD_Write(0xD201, 0x37);
SharpLCD_Write(0xD202, 0x0);
SharpLCD_Write(0xD203, 0x4A);
SharpLCD_Write(0xD204, 0x0);
SharpLCD_Write(0xD205, 0x6F);
SharpLCD_Write(0xD206, 0x0);
SharpLCD_Write(0xD207, 0x8D);
SharpLCD_Write(0xD208, 0x0);
SharpLCD_Write(0xD209, 0xAD);
SharpLCD_Write(0xD20A, 0x0);
SharpLCD_Write(0xD20B, 0xDF);
SharpLCD_Write(0xD20C, 0x1);
SharpLCD_Write(0xD20D, 0x11);
SharpLCD_Write(0xD20E, 0x1);
SharpLCD_Write(0xD20F, 0x58);
SharpLCD_Write(0xD210, 0x1);
SharpLCD_Write(0xD211, 0x76);
SharpLCD_Write(0xD212, 0x1);
SharpLCD_Write(0xD213, 0xA6);
SharpLCD_Write(0xD214, 0x1);
SharpLCD_Write(0xD215, 0xCD);
SharpLCD_Write(0xD216, 0x2);
SharpLCD_Write(0xD217, 0xE);
SharpLCD_Write(0xD218, 0x2);
SharpLCD_Write(0xD219, 0x46);
SharpLCD_Write(0xD21A, 0x2);
SharpLCD_Write(0xD21B, 0x48);
SharpLCD_Write(0xD21C, 0x2);
SharpLCD_Write(0xD21D, 0x78);
SharpLCD_Write(0xD21E, 0x2);
SharpLCD_Write(0xD21F, 0xAC);
SharpLCD_Write(0xD220, 0x2);
SharpLCD_Write(0xD221, 0xCD);
SharpLCD_Write(0xD222, 0x2);
SharpLCD_Write(0xD223, 0xFD);
SharpLCD_Write(0xD224, 0x3);
SharpLCD_Write(0xD225, 0x1F);
SharpLCD_Write(0xD226, 0x3);
SharpLCD_Write(0xD227, 0x4B);
SharpLCD_Write(0xD228, 0x3);
SharpLCD_Write(0xD229, 0x69);
SharpLCD_Write(0xD22A, 0x3);
SharpLCD_Write(0xD22B, 0x8E);
SharpLCD_Write(0xD22C, 0x3);
SharpLCD_Write(0xD22D, 0xA5);
SharpLCD_Write(0xD22E, 0x3);
SharpLCD_Write(0xD22F, 0xCD);
SharpLCD_Write(0xD230, 0x3);
SharpLCD_Write(0xD231, 0xF1);
SharpLCD_Write(0xD232, 0x3);
SharpLCD_Write(0xD233, 0xF1);
SharpLCD_Write(0xD300, 0x0);
SharpLCD_Write(0xD301, 0x37);
SharpLCD_Write(0xD302, 0x0);
SharpLCD_Write(0xD303, 0x4A);
SharpLCD_Write(0xD304, 0x0);
SharpLCD_Write(0xD305, 0x6F);
SharpLCD_Write(0xD306, 0x0);
SharpLCD_Write(0xD307, 0x8D);
SharpLCD_Write(0xD308, 0x0);
SharpLCD_Write(0xD309, 0xAD);
SharpLCD_Write(0xD30A, 0x0);
SharpLCD_Write(0xD30B, 0xDF);
SharpLCD_Write(0xD30C, 0x1);
SharpLCD_Write(0xD30D, 0x11);
SharpLCD_Write(0xD30E, 0x1);
SharpLCD_Write(0xD30F, 0x58);
SharpLCD_Write(0xD310, 0x1);
SharpLCD_Write(0xD311, 0x76);
SharpLCD_Write(0xD312, 0x1);
SharpLCD_Write(0xD313, 0xA6);
SharpLCD_Write(0xD314, 0x1);
SharpLCD_Write(0xD315, 0xCD);
SharpLCD_Write(0xD316, 0x2);
SharpLCD_Write(0xD317, 0xE);
SharpLCD_Write(0xD318, 0x2);
SharpLCD_Write(0xD319, 0x46);
SharpLCD_Write(0xD31A, 0x2);
SharpLCD_Write(0xD31B, 0x48);
SharpLCD_Write(0xD31C, 0x2);
SharpLCD_Write(0xD31D, 0x78);
SharpLCD_Write(0xD31E, 0x2);
SharpLCD_Write(0xD31F, 0xAC);
SharpLCD_Write(0xD320, 0x2);
SharpLCD_Write(0xD321, 0xCD);
SharpLCD_Write(0xD322, 0x2);
SharpLCD_Write(0xD323, 0xFD);
SharpLCD_Write(0xD324, 0x3);
SharpLCD_Write(0xD325, 0x1F);
SharpLCD_Write(0xD326, 0x3);
SharpLCD_Write(0xD327, 0x4B);
SharpLCD_Write(0xD328, 0x3);
SharpLCD_Write(0xD329, 0x69);
SharpLCD_Write(0xD32A, 0x3);
SharpLCD_Write(0xD32B, 0x8E);
SharpLCD_Write(0xD32C, 0x3);
SharpLCD_Write(0xD32D, 0xA5);
SharpLCD_Write(0xD32E, 0x3);
SharpLCD_Write(0xD32F, 0xCD);
SharpLCD_Write(0xD330, 0x3);
SharpLCD_Write(0xD331, 0xF1);
SharpLCD_Write(0xD332, 0x3);
SharpLCD_Write(0xD333, 0xF1);
SharpLCD_Write(0xD400, 0x0);
SharpLCD_Write(0xD401, 0x37);
SharpLCD_Write(0xD402, 0x0);
SharpLCD_Write(0xD403, 0x4A);
SharpLCD_Write(0xD404, 0x0);
SharpLCD_Write(0xD405, 0x6F);
SharpLCD_Write(0xD406, 0x0);
SharpLCD_Write(0xD407, 0x8D);
SharpLCD_Write(0xD408, 0x0);
SharpLCD_Write(0xD409, 0xAD);
SharpLCD_Write(0xD40A, 0x0);
SharpLCD_Write(0xD40B, 0xDF);
SharpLCD_Write(0xD40C, 0x1);
SharpLCD_Write(0xD40D, 0x11);
SharpLCD_Write(0xD40E, 0x1);
SharpLCD_Write(0xD40F, 0x58);
SharpLCD_Write(0xD410, 0x1);
SharpLCD_Write(0xD411, 0x76);
SharpLCD_Write(0xD412, 0x1);
SharpLCD_Write(0xD413, 0xA6);
SharpLCD_Write(0xD414, 0x1);
SharpLCD_Write(0xD415, 0xCD);
SharpLCD_Write(0xD416, 0x2);
SharpLCD_Write(0xD417, 0xE);
SharpLCD_Write(0xD418, 0x2);
SharpLCD_Write(0xD419, 0x46);
SharpLCD_Write(0xD41A, 0x2);
SharpLCD_Write(0xD41B, 0x48);
SharpLCD_Write(0xD41C, 0x2);
SharpLCD_Write(0xD41D, 0x78);
SharpLCD_Write(0xD41E, 0x2);
SharpLCD_Write(0xD41F, 0xAC);
SharpLCD_Write(0xD420, 0x2);
SharpLCD_Write(0xD421, 0xCD);
SharpLCD_Write(0xD422, 0x2);
SharpLCD_Write(0xD423, 0xFD);
SharpLCD_Write(0xD424, 0x3);
SharpLCD_Write(0xD425, 0x1F);
SharpLCD_Write(0xD426, 0x3);
SharpLCD_Write(0xD427, 0x4B);
SharpLCD_Write(0xD428, 0x3);
SharpLCD_Write(0xD429, 0x69);
SharpLCD_Write(0xD42A, 0x3);
SharpLCD_Write(0xD42B, 0x8E);
SharpLCD_Write(0xD42C, 0x3);
SharpLCD_Write(0xD42D, 0xA5);
SharpLCD_Write(0xD42E, 0x3);
SharpLCD_Write(0xD42F, 0xCD);
SharpLCD_Write(0xD430, 0x3);
SharpLCD_Write(0xD431, 0xF1);
SharpLCD_Write(0xD432, 0x3);
SharpLCD_Write(0xD433, 0xF1);
SharpLCD_Write(0xD500, 0x0);
SharpLCD_Write(0xD501, 0x37);
SharpLCD_Write(0xD502, 0x0);
SharpLCD_Write(0xD503, 0x4A);
SharpLCD_Write(0xD504, 0x0);
SharpLCD_Write(0xD505, 0x6F);
SharpLCD_Write(0xD506, 0x0);
SharpLCD_Write(0xD507, 0x8D);
SharpLCD_Write(0xD508, 0x0);
SharpLCD_Write(0xD509, 0xAD);
SharpLCD_Write(0xD50A, 0x0);
SharpLCD_Write(0xD50B, 0xDF);
SharpLCD_Write(0xD50C, 0x1);
SharpLCD_Write(0xD50D, 0x11);
SharpLCD_Write(0xD50E, 0x1);
SharpLCD_Write(0xD50F, 0x58);
SharpLCD_Write(0xD510, 0x1);
SharpLCD_Write(0xD511, 0x76);
SharpLCD_Write(0xD512, 0x1);
SharpLCD_Write(0xD513, 0xA6);
SharpLCD_Write(0xD514, 0x1);
SharpLCD_Write(0xD515, 0xCD);
SharpLCD_Write(0xD516, 0x2);
SharpLCD_Write(0xD517, 0xE);
SharpLCD_Write(0xD518, 0x2);
SharpLCD_Write(0xD519, 0x46);
SharpLCD_Write(0xD51A, 0x2);
SharpLCD_Write(0xD51B, 0x48);
SharpLCD_Write(0xD51C, 0x2);
SharpLCD_Write(0xD51D, 0x78);
SharpLCD_Write(0xD51E, 0x2);
SharpLCD_Write(0xD51F, 0xAC);
SharpLCD_Write(0xD520, 0x2);
SharpLCD_Write(0xD521, 0xCD);
SharpLCD_Write(0xD522, 0x2);
SharpLCD_Write(0xD523, 0xFD);
SharpLCD_Write(0xD524, 0x3);
SharpLCD_Write(0xD525, 0x1F);
SharpLCD_Write(0xD526, 0x3);
SharpLCD_Write(0xD527, 0x4B);
SharpLCD_Write(0xD528, 0x3);
SharpLCD_Write(0xD529, 0x69);
SharpLCD_Write(0xD52A, 0x3);
SharpLCD_Write(0xD52B, 0x8E);
SharpLCD_Write(0xD52C, 0x3);
SharpLCD_Write(0xD52D, 0xA5);
SharpLCD_Write(0xD52E, 0x3);
SharpLCD_Write(0xD52F, 0xCD);
SharpLCD_Write(0xD530, 0x3);
SharpLCD_Write(0xD531, 0xF1);
SharpLCD_Write(0xF532, 0x3);
SharpLCD_Write(0xD533, 0xF1);
SharpLCD_Write(0xD600, 0x0);
SharpLCD_Write(0xD601, 0x37);
SharpLCD_Write(0xD602, 0x0);
SharpLCD_Write(0xD603, 0x4A);
SharpLCD_Write(0xD604, 0x0);
SharpLCD_Write(0xD605, 0x6F);
SharpLCD_Write(0xD606, 0x0);
SharpLCD_Write(0xD607, 0x8D);
SharpLCD_Write(0xD608, 0x0);
SharpLCD_Write(0xD609, 0xAD);
SharpLCD_Write(0xD60A, 0x0);
SharpLCD_Write(0xD60B, 0xDF);
SharpLCD_Write(0xD60C, 0x1);
SharpLCD_Write(0xD60D, 0x11);
SharpLCD_Write(0xD60E, 0x1);
SharpLCD_Write(0xD60F, 0x58);
SharpLCD_Write(0xD610, 0x1);
SharpLCD_Write(0xD611, 0x76);
SharpLCD_Write(0xD612, 0x1);
SharpLCD_Write(0xD613, 0xA6);
SharpLCD_Write(0xD614, 0x1);
SharpLCD_Write(0xD615, 0xCD);
SharpLCD_Write(0xD616, 0x2);
SharpLCD_Write(0xD617, 0xE);
SharpLCD_Write(0xD618, 0x2);
SharpLCD_Write(0xD619, 0x46);
SharpLCD_Write(0xD61A, 0x2);
SharpLCD_Write(0xD61B, 0x48);
SharpLCD_Write(0xD61C, 0x2);
SharpLCD_Write(0xD61D, 0x78);
SharpLCD_Write(0xD61E, 0x2);
SharpLCD_Write(0xD61F, 0xAC);
SharpLCD_Write(0xD620, 0x2);
SharpLCD_Write(0xD621, 0xCD);
SharpLCD_Write(0xD622, 0x2);
SharpLCD_Write(0xD623, 0xFD);
SharpLCD_Write(0xD624, 0x3);
SharpLCD_Write(0xD625, 0x1F);
SharpLCD_Write(0xD626, 0x3);
SharpLCD_Write(0xD627, 0x4B);
SharpLCD_Write(0xD628, 0x3);
SharpLCD_Write(0xD629, 0x69);
SharpLCD_Write(0xD62A, 0x3);
SharpLCD_Write(0xD62B, 0x8E);
SharpLCD_Write(0xD62C, 0x3);
SharpLCD_Write(0xD62D, 0xA5);
SharpLCD_Write(0xD62E, 0x3);
SharpLCD_Write(0xD62F, 0xCD);
SharpLCD_Write(0xD630, 0x3);
SharpLCD_Write(0xD631, 0xF1);
SharpLCD_Write(0xD632, 0x3);
SharpLCD_Write(0xD633, 0xF1);
SharpLCD_Write(0xF000, 0x55);
SharpLCD_Write(0xF001, 0xAA);
SharpLCD_Write(0xF002, 0x52);
SharpLCD_Write(0xF003, 0x8);
SharpLCD_Write(0xF004, 0x0);
SharpLCD_Write(0xB400, 0x10);
SharpLCD_Write(0x3A00, 0x77);
SharpLCD_Write(0xB101, 0x0);
SharpLCD_Write(0x1100, 0x0);
wait_ms(64); // Delay 0x64ms);
SharpLCD_Write(0x2900, 0x0);
wait_ms(64); // Delay 0x64ms);
}

