 //  4180 Lab 1, Part 3
//  Gregory Lanier

#include "mbed.h"
#include "PinDetect.h"

/*
    This program uses PWM with two buttons and a DIP switch to control the color and brightness of an RGB LED.
*/

// Global Vars
float brightness = 0.5f;   // Initial brightness 1/2 power

// I/O
PinDetect   dimButton(p8);      // Make LED dimmer with p8 button
PinDetect   brightButton(p9);   // Make LED brighter with p9 button
DigitalIn   rDIP(p15);  // Switch 1 for Red LED with p15
DigitalIn   gDIP(p16);  // Switch 2 for Green LED with p16
DigitalIn   bDIP(p17);  // Switch 3 for Blue LED with p17
PwmOut  rLED(p21);  // Light up Red LED with p21
PwmOut  gLED(p22);  // Light up Green LED with p22
PwmOut  bLED(p23);  // Light up Blue LED with p23

// Dim Callback
void dim_callback(void) {
    brightness -= 0.1f;
}

// Brighten Callback
void bright_callback(void) {
    brightness += 0.1f;
}

int main()
{
    // Button Mode Set
    dimButton.mode(PullUp);    
    brightButton.mode(PullUp);
    wait(0.01);
    
    // Switch Mode Set
    rDIP.mode(PullUp);
    gDIP.mode(PullUp);
    bDIP.mode(PullUp);
    
    // Setuo button callbacks
    dimButton.attach_deasserted(&dim_callback);    
    brightButton.attach_deasserted(&bright_callback);
    
    // Start sampling button inputs using interrupts
    dimButton.setSampleFrequency();
    brightButton.setSampleFrequency();
    
    // Logic Loop
    while(1) {

        if (!rDIP){
            rLED = brightness;
            }
        else{
            rLED = 0;
            }
        
        if (!gDIP){
            gLED = brightness;
            }
        else{
            gLED = 0;
            }
            
        if (!bDIP){
            bLED = brightness;
            }
        else{
            bLED = 0;
            }
        }
}