#include<mbed.h>
#include "MPU3300.h"                 //header file which includes all the register addresses and
                    //Bit configuration of those registers
SPI spi (PTD6,PTD7,PTD5) ;      // MOSI,MISO, CLOCK pins being used on                                                                                              //microcontroller(in order)     
DigitalOut ssn (PTA13);         //Slave Select pin 
Serial pc(USBTX,USBRX);
InterruptIn dr(PTD2);       //Interrupt pin 
Ticker tr;              //Ticker function to give values for limited amount of time
uint8_t trFlag;         //ticker Flag 
uint8_t drFlag;         //data-ready interrupt flag
void trSub();               
void drSub(); 
void init_gyro();       
void execute_gyro();
int main(void)          
{
    init_gyro();                //Initializing Gyroscope registers and setting them to our required configuration
    execute_gyro();         //Executing gyroscope for measuring angular rates
    return 0;
}
void drSub()            //In this function we setting data-ready flag to 1              
{
    drFlag=1;
}
void trSub()                    //In this function we are setting ticker flag to 0
{
    trFlag=0;
}
void init_gyro()
{
    uint8_t response;               
    ssn=1;                  //Deselecting the chip 
    spi.format(8,3);                // Spi format is 8 bits, and clock mode 3 
    spi.frequency(1000000);     //frequency to be set as 1MHz
    drFlag=0;                   //Intially defining data-ready flag to be 0 
    dr.mode(PullDown);          
    dr.rise(&drSub);
    __disable_irq();
    
/*Following the above mentioned algorithm for initializing the register and changing its configuration*/
    ssn=0;                      //Selecting chip(Mpu-3300)
    spi.write(USER_CTRL|READFLAG);   //sending USER_CTRL address with read bit
    response=spi.write(DUMMYBIT);   //sending dummy bit to get default values of the register
                        
    ssn=1;                  //Deselecting the chip  
    wait(0.1);                  //waiting according the product specifications 
    
    ssn=0;                  //again selecting the chip  
    spi.write(USER_CTRL);           //sending USER_CTRL address without read bit 
    spi.write(response|BIT_I2C_IF_DIS);  //disabling the I2C mode in the register
    ssn=1;                  //deselecting the chip 
    wait(0.1);                  // waiting for 100ms before going for another register 
    
    ssn=0;
    spi.write(PWR_MGMT_1|READFLAG); //Power Management register-1 
    response=spi.write(DUMMYBIT);
    ssn=1;
    wait(0.1);
        
    ssn=0;
    spi.write(PWR_MGMT_1);
    response=spi.write(response|BIT_CLKSEL_X);  //Selecting the X axis gyroscope as clock as mentioned above 
    ssn=1;                          
    wait(0.1);
    
    ssn=0;
    spi.write(GYRO_CONFIG|READFLAG); //sending GYRO_CONFIG address with read bit
    response=spi.write(DUMMYBIT);
    ssn=1;
    wait(0.1);
    
    ssn=0;
    spi.write(GYRO_CONFIG); //sending GYRO_CONFIG address to write to register
    spi.write(response&(~(BITS_FS_SEL_3|BITS_FS_SEL_4))); //selecting a full scale mode of +/=225 deg/sec
    ssn=1;
    wait(0.1);
    
    ssn=0;
    spi.write(CONFIG|READFLAG); //sending CONFIG address with read bit
    response=spi.write(DUMMYBIT);
    ssn=1;
    wait(0.1);
    
    ssn=0;
    spi.write(CONFIG); //sending CONFIG address to write to register
    spi.write(response|BITS_DLPF_CFG); //selecting a bandwidth of 42 hz and delay of 4.8ms
    ssn=1;
    wait(0.1);
    
    ssn=0;
    spi.write(SMPLRT_DIV|READFLAG); //sending SMPLRT_DIV address with read bit
    response=spi.write(DUMMYBIT);
    ssn=1;
    wait(0.1);
        
    ssn=0;
    spi.write(SMPLRT_DIV); //sending SMPLRT_DIV address to write to register
    spi.write(response&BITS_SMPLRT_DIV); //setting the sampling rate division to be 0 to make sample rate = gyroscopic output rate
    ssn=1;
    wait(0.1);
    
    ssn=0;
    spi.write(INT_ENABLE|READFLAG);       //sending address of INT_ENABLE with readflag
    response=spi.write(DUMMYBIT);              //sending dummy byte to get the default values of the
                                                                          // regiser
    ssn=1;   
    wait(0.1);
    
    ssn=0;
    spi.write(INT_ENABLE);                           //sending INT_ENABLE address to write to register
    spi.write(response|BIT_DATA_RDY_ENABLE);  //Enbling data ready interrupt
    ssn=1;
    wait(0.1);
    
    __enable_irq();
}

void execute_gyro()
{
    uint8_t response;
    uint8_t MSB,LSB;
    int16_t bit_data;
    float data[3],error[3]={0,0,0}; //declaring error array to add to the values when required
    float senstivity = 145.6;     //senstivity is 145.6 for full scale mode of +/-225 deg/sec
    ssn=0;
    spi.write(PWR_MGMT_1|READFLAG); //sending address of INT_ENABLE with readflag
    response=spi.write(DUMMYBIT); //
    ssn=1;
    wait(0.1);
        
    ssn=0;
    spi.write(PWR_MGMT_1); //sending PWR_MGMT_1 address to write to register
    response=spi.write(response&(~(BIT_SLEEP))); //waking up the gyroscope from sleep
    ssn=1;
    wait(0.1);
    
    trFlag=1;
    tr.attach(&trSub,1); //executes the function trSub afer 1sec
    while(trFlag)
    {
        if(drFlag==1)
        {
            ssn=0;
            spi.write(GYRO_XOUT_H|READFLAG); //sending address of PWR_MGMT_1 with readflag
            for(int i=0;i<3;i++)
            {
                MSB = spi.write(DUMMYBIT); //reading the MSB values of x,y and z respectively
                LSB = spi.write(DUMMYBIT); //reading the LSB values of x,y and z respectively
                bit_data= ((int16_t)MSB<<8)|LSB; //concatenating to get 16 bit 2's complement of the required gyroscope values
                data[i]=(float)bit_data;
                data[i]=data[i]/senstivity; //dividing with senstivity to get the readings in deg/sec
                data[i]+=error[i]; //adding with error to remove offset errors
            }
            ssn=1;      
            for (int i=0;i<3;i++)
            {
                printf("%f\t",data[i]); //printing the angular velocity values
            }
            printf("\n");
            break;
        }
            drFlag=0;
    }
    ssn=0;
    spi.write(PWR_MGMT_1|READFLAG); //sending address of PWR_MGMT_1 with readflag
    response=spi.write(DUMMYBIT);
    ssn=1;
    wait(0.1);
        
    ssn=0;
    spi.write(PWR_MGMT_1); //sending PWR_MGMT_1 address to write to register
    response=spi.write(response|BIT_SLEEP); //setting the gyroscope in sleep mode
    ssn=1;
    wait(0.1);
}
