#include "mbed.h"
#include "rtos.h"
#include "pin_config.h"
//#include "HK.h"
#include "ACS.h"
//#include "beacon.h"

Serial pc(USBTX, USBRX);
InterruptIn irpt_4m_mstr(PIN38);                                      //I2c interrupt from CDMS
DigitalOut irpt_2_mstr(PIN4);                                        //I2C interrupt to CDMS
I2CSlave slave (PIN1,PIN2);
const int addr = 0x20;                                            //slave address 
Thread *ptr_t_i2c;
Timer t;                  // time taken from isr to reach i2c function
Timer t1;
Timer t_exec;                                                        //To know the time of execution each thread

Timer t_start;                                                       //To know the time of entering  of each thread
Timer t_i2c_start;                                                       //To check the time sync in i2c communication
Timer t_i2c_exec;                                                       //To know the time taken by i2c read/write function

Thread *ptr_t_hk;
Thread *ptr_t_acs;
Thread *ptr_t_bea;

/**************************************************************global variables*********************************************************************************/
char hk_data[25];

/**************************************************************funtion header**********************************************************************************/

void FCTN_HK_DATA_CATENATE();   
 

//---------------------------------------------------------------------------------------------------------------------------------------------------
//TASK : HK
//---------------------------------------------------------------------------------------------------------------------------------------------------
//extern SensorDataQuantised SensorQuantised;
void T_HK(void const *args)
{
   while(1){
        Thread::signal_wait(0x2);
        //SensorQuantised.power_mode='3';                          //default power mode(dummy)
//        printf("\n\rTHIS IS HK    %f\n\r",t_start.read());
//        t_exec.start();
//        FCTN_HK_MAIN();                                             //Collecting HK data
//        FCTN_HK_DATA_CATENATE();                                      //sending HK data to CDMS
//        t_exec.stop();
//        //printf("The time to execute hk_acq is %f seconds\n\r",t_exec.read());
//        t_exec.reset();
    printf("\n\rTHIS IS HK    %f\n\r",t_start.read());
   }
    
    }
//---------------------------------------------------------------------------------------------------------------------------------------------------
//TASK : ACS data
//---------------------------------------------------------------------------------------------------------------------------------------------------

void T_ACS(void const *args){
       
    float mag_field1[3];
    float omega1[3];
    //float tauc1[3];
    //float moment[3];
    //float *mnm_data;
    while(1)
    {
        Thread::signal_wait(0x1);
        printf("\n\rEntered ACS   %f\n",t_start.read());
        FCTN_ATS_DATA_ACQ(omega1,mag_field1); //the angular velocity is stored in the first 3 values and magnetic field values in next 3
        printf("\n\rmnm gyro values\n"); //printing the angular velocity and magnetic field values
        for(int i=0; i<3; i++) 
        {
            printf("%f\t",omega1[i]);
        }
        printf("\n\r mnm mag values\n");
        for(int i=0; i<3; i++) 
        {
            printf("%f\t",mag_field1[i]);
        }
        t_exec.reset();

    }
}
//---------------------------------------------------------------------------------------------------------------------------------------------------
//TASK : Beacon
//---------------------------------------------------------------------------------------------------------------------------------------------------
int beac_flag=0;
void T_BEA(void const *args){
       while(1){
       Thread::signal_wait(0x3);
        printf("\n\rTHIS IS BEACON    %f\n\r",t_start.read());
//        t_exec.start();
//        FCTN_BEA_MAIN();
//        if(beac_flag==1)
//        {
//            Thread::wait(600000);
//            beac_flag = 0;
//        }
//        printf("The time to execute beacon thread is %f seconds\n\r",t_exec.read());
//        t_exec.reset();
    }
}



//extern SensorDataQuantised SensorQuantised;


//---------------------------------------------------------------------------------------------------------------------------------------------------
//TASK : Scheduler
//---------------------------------------------------------------------------------------------------------------------------------------------------

uint8_t schedcount=1;
void T_SC(void const *args)
{    
    
   
    if(schedcount == 4)                         //to reset the counter
    {
        schedcount = 1;
    }
     pc.printf("\n\rThe value of i in scheduler is %d\n\r",schedcount);
    if(schedcount%1==0)
    {
        ptr_t_acs -> signal_set(0x1);
    }
    
    if(schedcount%2==0)
    {
        ptr_t_hk -> signal_set(0x2);
        
    }
    if(schedcount%3==0)
    {
    
           ptr_t_bea -> signal_set(0x3);
        
    }
    schedcount++;
}
//---------------------------------------------------------------------------------------------------------------------------------------------------
//TASK : i2c data
//---------------------------------------------------------------------------------------------------------------------------------------------------
//void FCTN_I2C_READ(char *data,int length);
//void FCTN_I2C_WRITE(char *data,int length);


bool write_ack = 1;
bool read_ack = 1;
char data_send[10];
char data_receive[10];
char short_tc[10];
char long_tc[134];
char mstr_cmd = '0';
bool cmd_flag = 1;
int length=10;

void T_I2C_SLAVE(void const * args)
{
     while(1)
    {
        cmd_flag = 1;
        Thread::signal_wait(0x4);
        wait_us(100);                                               // can be between 38 to 15700
        //printf("\n\r check 1\n");
        t.stop();
        if( slave.receive() == 0) 
            slave.stop();                  
        if( slave.receive() == 1)                                     // slave writes to master
        {
            t1.start();
            write_ack=slave.write(data_send,length);       
            t1.stop(); 
            if(write_ack == 0)
            printf("\n\rData sent to CDMS is %s \n",data_send);     
            slave.stop();    
        }
        if( slave.receive()==3 ||  slave.receive()==2)             // slave read 
        {
            t1.start();
            read_ack=slave.read(data_receive,length);
            t1.stop();
            if(read_ack == 0)
            printf("\n\r Data received from CDMS is %s \n",data_receive);
            slave.stop();
        }   
        printf("\n \r %d %d\n",t.read_us(),t1.read_us());
        t.reset();
        t1.reset(); 
        }
        
 //         if(cmd_flag == 1)
//        {
//            t.stop();
//            if( slave.receive()==3 ||  slave.receive()==2)             // slave read 
//            {
//                
//                t1.start();
//                read_ack=slave.read(&mstr_cmd,1);
//                t1.stop();
//                if(read_ack == 0)
//                {
//                    printf("\n\r Data received from CDMS is %c \n",mstr_cmd);
//                    switch(mstr_cmd)
//                    {
//                        case 's':
//                        length = 11;
//                        cmd_flag = 0;
//                        break;
//                    
//                        case 'l':
//                        length = 135;
//                        cmd_flag = 0;
//                        break;
//                    
//                        case 'h':
//                        length = 25;
//                        cmd_flag = 0;
//                        FCTN_I2C_WRITE(hk_data,length );
//                        break;
//                    
//                        default:
//                        printf("\n\r invalid command \n");
//                    //cmd_err = 0;
//                        cmd_flag = 1;
//                    }
//                }
//                    else
//                    cmd_flag = 1;   
//            }   
//            else
//                cmd_flag = 1;
//        }
//        printf("\n \r %d %d\n",t.read_us(),t1.read_us());
//        t.reset();
//        t1.reset();
//       
//       
//    }
//}
//
//void FCTN_I2C_READ(char *data, int length )
//{
//    t1.start();
//    read_ack=slave.read(data,length);
//    t1.stop();
//    if(read_ack == 0)
//        printf("\n\rData received from CDMS is %s \n",data);
//    else
//        printf("\n\r data not received \n");
//}
//
//void FCTN_I2C_WRITE(char *data,int length)
//{
//    t1.start();
//    write_ack=slave.write(data,length);
//    t1.stop();       
//    if(write_ack == 0)
//        printf("\n\rData sent to CDMS is %s \n",data);
//    else 
//        printf("\n\r data not sent\n");
}


void FCTN_ISR_I2C()
{
     ptr_t_i2c->signal_set(0x4); 
     t.start();
}
//void FCTN_HK_DATA_CATENATE()
//{
//        strcpy(hk_data,"hk_Data");
//        strcat(hk_data,SensorQuantised.Voltage);
//        strcat(hk_data,SensorQuantised.Current); 
//        strcat(hk_data,SensorQuantised.PanelTemperature);
//        strcat(hk_data,SensorQuantised.AngularSpeed);
//        strcat(hk_data,SensorQuantised.Bnewvalue);
//        char fdata[5] = {SensorQuantised.BatteryTemperature,SensorQuantised.faultpoll,SensorQuantised.faultir,SensorQuantised.power_mode};
//        /*strcat(hk_data,sfaultpoll);
//        strcat(hk_data,sfaultir);
//        strcat(hk_data,spower_mode);*/
//        strcat(hk_data,fdata);
//        printf("\n\r hk data being sent is %s ",hk_data);
//}

//----------------------------------------------------------------------------BAE_INIT-------------------------------------------------------------

void FCTN_BAE_INIT()
{
    slave.address(0x20);                              // setting slave address for BAE for I2C communication
    FCTN_ACS_INIT();                                      // Initializing mnm blue
    //FCTN_BAE_HK_INIT();
    //FCTN_BEA_INIT();
}


//---------------------------------------------------------------------------------------------------------------------------------------------------
//TASK : Main
//---------------------------------------------------------------------------------------------------------------------------------------------------



int main(){
    ptr_t_hk = new Thread(T_HK);
    ptr_t_acs = new Thread(T_ACS);                    
    ptr_t_bea = new Thread(T_BEA);
    ptr_t_i2c= new Thread(T_I2C_SLAVE);
    
    ptr_t_acs->set_priority(osPriorityAboveNormal);
    ptr_t_hk->set_priority(osPriorityAboveNormal);
    ptr_t_bea->set_priority(osPriorityAboveNormal);
    ptr_t_i2c->set_priority(osPriorityRealtime);

    RtosTimer t_sc_timer(T_SC,osTimerPeriodic);               // Initiating the scheduler thread
    t_sc_timer.start(10000);
    printf("\n\r BAE ACTIVATED\n");
    FCTN_BAE_INIT();
    //strcpy(data_send,"sakthi");
    slave.address(addr); 
    irpt_4m_mstr.enable_irq();
    irpt_4m_mstr.rise(&FCTN_ISR_I2C);
        
   
    while(1)                                                   //required to prevent main from terminating
    {   
        ;
    }
}