#include "mbed.h"
#include "rtos.h"
Serial pc(USBTX, USBRX);

Thread *ptr_t_hk;
Thread *ptr_t_acs;
Thread *ptr_t_bea;

void T_HK(void const *args)
{
   while(1){
   Thread::signal_wait(0x2);
   pc.printf("HK thread here\r \n");
   }
    
    }
void T_ACS(void const *args){
       while(1){
       Thread::signal_wait(0x1);
       pc.printf(" ACS thread here\r \n");
       }
}
void T_BEA(void const *args){
       while(1){
       Thread::signal_wait(0x3);
       pc.printf("BEA thread here\r \n");
       }
}

uint8_t schedcount=1;
void T_SC(void const *args)
{    
    
   
    if(schedcount == 4)                         //to reset the counter
    {
        schedcount = 1;
    }
     pc.printf("\n\rThe value of i in scheduler is %d\n\r",schedcount);
    if(schedcount%1==0)
    {
        ptr_t_acs -> signal_set(0x1);
    }
    
    if(schedcount%2==0)
    {
        ptr_t_hk -> signal_set(0x2);
        
    }
    if(schedcount%3==0)
    {
    
           ptr_t_bea -> signal_set(0x3);
        
    }
    schedcount++;
}




int main(){
    ptr_t_hk = new Thread(T_HK);
    ptr_t_acs = new Thread(T_ACS);                    
    ptr_t_bea = new Thread(T_BEA);
    
    ptr_t_acs->set_priority(osPriorityAboveNormal);
    ptr_t_hk->set_priority(osPriorityAboveNormal);
    ptr_t_bea->set_priority(osPriorityAboveNormal);
    RtosTimer t_sc_timer(T_SC,osTimerPeriodic);               // Initiating the scheduler thread
    t_sc_timer.start(10000);     
   
    while(1)                                                   //required to prevent main from terminating
    {   
        ;
    }
}