#include "mbed.h"
#include "DS1820.h"

#define DATA_PIN        D12
#define minTemp  25.5
#define maxTemp  30.0


DS1820 probe(DATA_PIN);

PwmOut red(LED_RED);
PwmOut green(LED_GREEN);

int main() {
    float p = 0.0;
    red.period(0.001);
    
    for (float i=0.0; i<1.0; i+= 0.25) { 
       green = i;
       red = 1.0-i;
       wait(2.0);
    }
    
    while (true) {
        probe.convertTemperature(true, DS1820::all_devices);         //Start temperature conversion, wait until ready
        printf("It is %3.1foC\r\n", probe.temperature());
        p = (probe.temperature() - minTemp) / (maxTemp - minTemp);
        printf("LED Value %f\r\n", p);
        green = p;
        red = 1.0 -p;
        wait (.5);
    }
}