/*----------------------------------------------------------------------------
LAB EXERCISE - Simple BLE Beacon
 ----------------------------------------
	In this exercise we will create a BLE beacon which transmits data to
    other devices.

	GOOD LUCK!
 *----------------------------------------------------------------------------*/

#include "mbed.h"
#include "nRF51822n.h"

// Create an instance of the BLE radio driver and an instance of a Ticker
// <Write your code here>


// Create two DigitalOut instances for LEDs
// <Write your code here>


// Give your beacon a name and add some service data
const static char deviceName[] = "** <Insert beacon name> **";
const static int serviceData[] = {0x0000, 0xAAAABBB};

// Create two GapAdvertisingData instances. One for advertising data and another for the scan response
// <Write your code here>


// Create a GapAdvertisingParams instance for advertising parameters
// <Write your code here>


class GapEventHandler : public GapEvents {
	// When a client device connects, turn off the advertising LED
	virtual void onConnected(void){
		// <Write your code here>
        
	}

	// When a client device disconnects we need to start advertising again and turn on the advertising LED
	virtual void onDisconnected(void){
		// <Write your code here>
        
	}
};

void blinky(void){
    // Blink one LED every 1 second
    // <Write your code here>


}

/*----------------------------------------------------------------------------
 MAIN function
 *----------------------------------------------------------------------------*/

int main(void){
	// Attach the Ticker
    // <Write your code here>
    
    
    // Set the GAP event handler
	nrf.getGap().setEventHandler(new GapEventHandler());
	
    // Start and reset the BLE radio
    // <Write your code here>


	// Add BLE-Only flag and advertising data as well as scan response data to the payload
    advData.addFlags((GapAdvertisingData::Flags)(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE));
	advData.addData(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t*)deviceName, sizeof(deviceName));
    scanResponse.addData(GapAdvertisingData::SERVICE_DATA, (uint8_t*)serviceData, sizeof(serviceData));
	advData.addAppearance(GapAdvertisingData::GENERIC_THERMOMETER);
	// Add the advertising and scan response data to the payload    
    // <Write your code here>
    

	// Start advertising (make sure you've added all your data first) and set the advertising LED to high
    // <Write your code here>
    

	while(1) {
    // Leave the while loop empty
	}
}

// *******************************ARM University Program Copyright © ARM Ltd 2014*************************************
