#include "mbed.h"
#include "MIDI.h"
#include "main.h"
#include <stdlib.h>
#include <string.h>

#define CH_VOICE 1;

void setup_eVY1(void);

DigitalOut myled(LED1);
MIDI evy1(p9, p10);
int ch_use = CH_VOICE;

// DO NOT EDIT!!
const char* phoneticSymbols[] = {
    "a", "i", "M", "e", "o",        // あいうえお0-4
    "k a", "k' i", "k M", "k e", "k o", // かきくけこ5-9
    "s a", "S i", "s M", "s e", "s o", // さしすえそ10-14
    "t a", "tS i", "ts M", "t e", "t o",    // たちつてと15-19
    "n a", "J i", "n M", "n e", "n o",  //なにぬねの20-24
    "h a", "C i", "p\\ M", "h e", "h o",    // はひふへほ25-29
    "m a", "m' i", "m M", "m e", "m o", // まみむめも30-34
    "j a","i", "j M","e","j o",//やいゆえよ35-39
    "4 a", "4' i", "4 M", "4 e", "4 o", // らりるれろ40-44
    "w a","w o","N\\","","",// わをん 45-49
    "g a", "g' i", "g M", "g e", "g o",//がぎぐげご　50-54
    "dz a", "dZ i", "dz M", "dz e", "dz o",//ざじずぜぞ55-59
    "d a", "dZ i", "dz M", "d e", "d o",//だじづでど60-64
    "b a", "b' i", "b M", "b e", "b o",//ばびぶべぼ  65-69
    "p a", "p' i", "p M", "p e", "p o"//ぱぴぷぺぽ70-74
}; 

void setup_eVY1(void){
    evy1.begin(ch_use);
}

/*
int make_lylic(){
    int i;
    int* lylic;
    int lylics[]={5,3,42,24,2,15,50,6,9,3,18,7,42,39};
    
    lylic = (int*)malloc(sizeof(lylics));
    if(lylic == NULL)return (-1)
    
    for(i=0; i<sizeof(lylics)/sizeof(lylics[0]); i++){
        lylic[i] = phoneticSymbols[lylics[i]];
        }
    free(lylic);
}
*/
void send_lylic(uint8_t mode){
    int i, j;
    int len;
    int lylics[]={5,3,42,24,2,15,50,6,9,3,18,7,42,39};
    int len_lylics = sizeof(lylics)/sizeof(lylics[0]);

    byte header[] = {0xF0,0x43,0x79,0x09,0x00,0x50,0x10|mode};
    byte lylic[] = {'a'};
    byte sepalate[] = {','};
    byte footer[] = {0x00,0xF7};
    
    int len_header = sizeof(header)/sizeof(header[0]);
    int len_lylic = sizeof(lylic)/sizeof(lylic[0]);
    int len_sepalate = sizeof(sepalate)/sizeof(sepalate[0]);
    int len_footer = sizeof(footer)/sizeof(footer[0]);

    evy1.sendSysEx(len_header, header, true);
    for(i=0; i<len_lylics; i++){
        len = strlen(phoneticSymbols[lylics[i]]);
        for(j=0; j<len;j++){
            lylic[0] = phoneticSymbols[lylics[i]][j];
            evy1.sendSysEx(len_lylic, lylic, true);
            }
        if(i<len_lylics-1) evy1.sendSysEx(len_sepalate, sepalate, true);
        }
    evy1.sendSysEx(len_footer, footer, true);
}

int main() {
    int i;
    int key = 0x3c; //C
    int ch1 = CH_VOICE;
      
    //setup
    setup_eVY1();
    
    //make lylic
    
    //send lylic
    send_lylic(0x00);//mode replace:0x00, append:0x01
    
    //send MIDI message
    char mml[] ="CDEFEDC EFGAGFE";
    int mml_len = sizeof(mml) / sizeof(mml[0]);
    
    for(i = 0;i< mml_len ;i++){
        char c = mml[i];
        if(c >= 'a' && c <='z') c-= 0x20;
        if((c>='A' && c<='Z')||c=='<'||c=='>'){
            //key send
            if(i!=0){
                evy1.sendNoteOn(key,0x7f,ch1);   
                wait(0.5);
            }
            key= 0x3c; 

            switch(c) {
                case 'C': break;
                case 'D': key+=2; break;
                case 'E': key+=4; break;
                case 'F': key+=5; break;
                case 'G': key+=7; break;
                case 'A': key+=9; break;
                case 'B': key+=11; break;
                default: break;
            }
        }
    }
    evy1.sendNoteOn(key, 0x7f, ch1);   // note on message. 0x90=1ch, 0x7f=Velocity
    wait(0.5);
    evy1.sendNoteOff(key, 0x7f, ch1);   // note on message. 0x90=1ch, 0x7f=Velocity
}