#include "mbed.h"
#include <Pulse.h>
#include "DebouncedIn.h"
#define off 1
#define on 0

Serial pc(USBTX,USBRX); // Abre puerto serial
Serial GSM(PTE0,PTE1);

DigitalOut LedVerde(LED2,off);
DigitalOut LedRojo(LED1,off);

AnalogIn input(PTC2);
InterruptIn sw2(PTA13);

Timer t;  //Configura el timer

int tiempo;
int cPulsos; // Cuenta los pulsos
int Bmax = 1; // Límite de agua máximo del recipiente de la bomba
int i, j, k, m, num;
bool saver = true; // Para terminar el programa.

void sw2_release(void)  //esta me dispara el timer iniciando en 0.0000
{
    t.reset();
    t.start();
    i=0;                 //note que si i=0 es por que se dio pulso completo
}    
 
void sw2_pull(void)  //esta detiene el timer (primero) y luego lee el valor en microsegundos, con tiempo en valor entero
{
    t.stop();
    tiempo=t.read_us();
    
}

void sendData(float input)
{
    wait(1);
    num = input*1000;      //agrando el numero de cero a mil
    GSM.putc(num);
    pc.printf("Nivel del tanque: %f [m].\r\n", input);
    if(num < 256) {          //debo generar dos casos a APP inventor solo me recibe hex asi: 0xhhhh (4 cifras)
        GSM.putc(0);     //si el numero es hasta 255 se le ponen dos ceros adelante a la secuencia de bits
        GSM.putc(i);     //luego la cifra menos significativa
        //pc.printf("Cero: %d\r\n", 0);
        //pc.printf("m: %d\r\n", m);
    }
    if(num >255) {         //pero si es mayor a 255 las cifras deben ser convertidas a un hex de dos bytes de la siguiente forma
        j = num/256;       //calculo la cifra mas significativa
        k = num - j*256;     //calculo la cifra menos significativa
        GSM.putc(j);   //las envio a la usart para que se las ponga al modulo bluetooth y la lleve al android
        GSM.putc(k);   //mas significativa primero, menos despues si no no funciona!!! y con la orden PUTC solo asi le envia binarios
        //pc.printf("j: %d\r\n", j);
        //pc.printf("k: %d\r\n", k);
    }
}


int main()
{
    GSM.baud(9600);   // asigno baudios y configuro puerto serie de la usart
    GSM.format(8,Serial::None,1);
    wait(1);
    pc.printf(" Iniciando WaterSaver\r\n");
 
    // Inicia el ciclo
    while(saver) {
waitPulse: // en esta parte se identifican los tiempo de los pulsos

          sw2.fall(&sw2_release);
          sw2.rise(&sw2_pull);
          wait(0.5);
          pc.printf("tiempo = %i\r\n",tiempo); 
          pc.printf("Esperando flujo de la lavadora...\r\n");
            if ((5000<=tiempo)) {
                goto comenzar;
            } else {
        goto waitPulse;
        }
comenzar:
          sw2.fall(&sw2_release);
          sw2.rise(&sw2_pull);
          pc.printf("tiempo = %i\r\n",tiempo); 
        if(tiempo<5000) {
            goto waitPulse;
        } else {
            cPulsos = 0;
            pc.printf("\r\n");
            pc.printf("Se detecta flujo.\r\n");
            LedVerde = on;
            goto llenar;
        }

llenar: // envia flujo a donde se encuentra la bomba para desplazar el agua al tanque principal
        int j = 0;
        while(j <= Bmax) { // Ciclo de en envio de fluido a la bomba principal
        
            if(j == Bmax) {
                pc.printf("Se debe prender la bomba.\r\n");
                goto Tanque;
            } else {
                pc.printf("Enviando flujo\r\n");
                wait(1);
            }
            j++;
        }

Tanque:
        float limax = 1;
        for(float l = 0; l <= limax; l += 0.033333333) {
            sw2.fall(&sw2_release); 
          sw2.rise(&sw2_pull);
          pc.printf("tiempo = %i\r\n",tiempo); 
        if(tiempo<5000) {
            goto waitPulse;
        }         
            
            
            if (l == limax) { // Significa que se ha llenado el tanque y se debe alertar.
                pc.printf("Se ha llenado el tanque. Favor abrir la valvula del desague.\r\n");
                goto desague;
            } else {
                sendData(l); // Enviar dato a la aplicación de llenado de tanque
            }
        }


desague:
        LedRojo = on;
        wait(1);
        LedRojo = off;
        wait(1);

pc.printf("tiempo = %i\r\n",tiempo); 

        pc.printf("presione 'v' para abrir la valvula del tanque: ");
        char c = pc.getc();
        //char c = 'a'; // Agilidad
        pc.printf("\r\n");
        pc.printf("Se inicia la descarga del tanque. \r\n");

        LedRojo = on;
               
        if(c == 'v') {
            float limTmin = 0;
            for(float l1 = 1; l1 >= limTmin; l1 -= 0.033333333) {
                if (l1 == 0) { // Significa que se ha llenado el tanque y se debe alertar.
                    pc.printf("Se ha liberado el tanque. Comprobando flujo...\r\n");
                    wait(1);
                    goto llenar;
                } else {
                    sendData(l1); // Enviar dato a la aplicación de llenado de tanque
                }
            }
        }
    }
}


