#include "mbed.h"
#include <Pulse1.h>

//control remoto SAMSUNG
PulseInOut irda(PTD7);// en este puerto se pone el sensor infrarrojo
Serial pc(USBTX, USBRX);
DigitalOut ab(PTD0);
DigitalOut ce(PTD1);

int header =0; //tiempo de cabecera pulso abajo
const int head_H = 4972; //+10% medida con osciloscopio en microsegundos
const int head_L = 4068;//-10%  medida con osciloscopio
int i=0;
const int T_alto = 1680;//ponga su tiempo de la prueba
const int T_bajo = 640;//ponga su tiempo de la prueba
const int num_bits = 32;//ponga su numero de bits
int num[num_bits];//cadena para almacenar todos los tiempos que conforman los bits de datos
int dato; // tiempo de cada dato que se lee
char v[num_bits]; // vector usado para guardar los datos del boton que se aprete
char vi[num_bits]= {1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,1,1,1,1,1}; // Codigo del boton ON, el cual se usara para encender o apagar la valvula
int con; // Variable auxiliar
 
int main(){
while(1){
ini1: fflush( stdin );
    header=0;
    header = irda.read_low_us();    //funcion para leer un pulso de caida o bajo en header
        if (header > head_L && header < head_H) goto seguir;//verificar que este en la tolerancia +-10%
        else goto ini1;
      
seguir:
    //leo los datos de la trama y se meten a un arreglo
    wait_us(4480);// ES EL TIEMPO DE HEADER QUE NO SE Lee O EL ALTO 
        for(i=0;i<(num_bits-1);++i){ // POR OSCILOSCOPIO se determina que llegan (num_bits),datos
            dato = irda.read_high_us(); //leer un bit de datos que es pulso arriba en este control
            num[i]=dato;
            wait_us(300);   ////////////
        }
    wait(0.5); //espero un poquito luego de leer todo el arreglo y ponerlo en pantalla 
    pc.printf("\n\n");
        for(i=0;i<(num_bits-1);++i){  
            if(num[i] > ((T_alto+T_bajo)/2)){
                pc.printf("1");
                v[i]=1; // Guarda 1 en las posiciones del vector donde el pulso es alto
            }
            else {
                pc.printf("0");
                v[i]=0; // Guarda 0 en las posiciones del vector donde el pulso es bajo            
            }
        }
   con=0;
    for (i=0; i<(num_bits-1);++i){ 
        if (vi[i]==v[i]){ // Comparación de los codigos
            con=con+1; // Si la posición de los vectores es igual aumenta el contador
        }
    }        
        if (con==(num_bits-1)){ // Si el contador es igual al numero de bits, indica que la cadena es correcta
            ab=1;
            ce=0;
            pc.printf("\nAbriendo valvula\n");
            wait(6);
            ab=0;
            ce=1;
            pc.printf("Cerrando valvula\n");  
            wait(2);
            ab=0;
            ce=0;
                  
        }
        else{ // Si el contador es diferente, la cadena es incorrecta
            ab=0;
            ce=0;
            pc.printf("\nTecla equivocada");            
        }      
}
}