#include "mbed.h"
#include "Rtc_Ds1307.h"
#include "TextLCD.h"
#include "DebouncedIn.h" 
#include "QEI.h" 

TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7
//RtcCls rtc(p28, p27, p29, true);
Rtc_Ds1307 rtc(PTE0, PTE1);
 
Serial pc(USBTX, USBRX, "pc");
 
QEI wheel (PTA13, PTD5, NC, 100); // Puertos del encoder
 
//Se programan los botones 
DebouncedIn BotonENC(PTC17); // botón propio del encoder 
DebouncedIn Boton2(PTE31);   // boton utilizado para confirmar
 
//Salidas digitales para el uso de leds, los cuales simulan el sonido de la alarma
DigitalOut myled(PTE20);
DigitalOut myled2(PTE21);

//Se inicializan las variables
int dia = 1,mes = 1,ano = 2016,hh = 0,mm = 0,ss = 0;
char buffer[128];
int readptr = 0;
int start = 0;
int Config;
int contador = 0;

 
int main() {
    char c;
    Rtc_Ds1307::Time_rtc tm = {};
    
    while(1) {
        set_reloj:           
        pc.printf("*************************************\n");
        pc.printf("* Menu for RTC Test :               *\n");
        pc.printf("* read  - reads the clock           *\n");
        pc.printf("* start - start the clock           *\n");
        pc.printf("* stop  - stop the clock            *\n");
        pc.printf("* write - write the clock           *\n");
        pc.printf("*************************************\n");
        
        while( (c = pc.getc()) != '\n') {
            buffer[readptr++] = c;
        }
        buffer[readptr++] = 0;
        if (strncmp(buffer, "read", 4) == 0) {
              //perform read
            pc.printf("Lectura del reloj\n");
            
lop1:   if (rtc.getTime(tm) ) {
            
            pc.printf("La hora actual es : %02d:%02d:%02d\n", tm.hour, tm.min, tm.sec); // Me entrega la hora actual
            pc.printf("La fecha actual es : %s, %02d/%02d/%04d\n", rtc.weekdayToString(tm.wday), tm.mon, tm.date, tm.year); // Me entrega la fecha actual
          
           lcd.cls();
                lcd.locate(0,0);
                lcd.printf("%02d:%02d:%02d", tm.hour, tm.min, tm.sec); // Me entrega la hora actual
                lcd.locate(0,1);
                lcd.printf("%s/%02d/%02d/%4d", rtc.weekdayToString(tm.wday), tm.date, tm.mon, tm.year);// Me entrega la fecha actual
                wait_ms(200); 
                if(BotonENC.falling()){
                    goto set_prev;
                    }           
                goto lop1;
            }
            
        }
        else if (strncmp(buffer, "write", 5) == 0) {
            // Se despliega el siguiente menú para configurar fecha y hora actual
            
            pc.printf("Ingrese el dia (fecha 1..31):");// Se pide ingresar un número del 1 al 31 equivalente al día del mes
            pc.scanf("%d", &tm.date);
            pc.printf("Ingrese el mes (mes 1..12):");  // se pide ingresar un valor entre 1 y 12 que representa el mes  
            pc.scanf("%d", &tm.mon);
            pc.printf("Ingrese el ano (2016):");        // a continuación se ingresa el valor del año
            pc.scanf("%d", &tm.year);
            pc.printf("Ingrese la hora (horas 0..23):");// Luego se ingresa la hora en formato 24 horas
            pc.scanf("%d", &tm.hour);
            pc.printf("Ingrese los minutos (minutos 0..59):");// Se ingresan los minutos
            pc.scanf("%d", &tm.min);
            pc.printf("Ingrese los segundos (segundos 0..59)"); //Y por último los segundos (cualquier valor, ya que es díficil su precisión)
            pc.scanf("%d", &tm.sec);
            pc.printf("Ingrese el dia(Sab=0, Dom=1, Lun=2, Mar=3, Mier=4, Juev=5, Vier=6):");
            pc.scanf("%d", &tm.wday);
            pc.printf("Realizando la operacion... Por favor espere\n"); // Se espera la configuración de esos valores
            
            while(pc.readable()) 
                pc.getc();
            rtc.setTime(tm, false, false);
        }
        else if (strncmp(buffer, "start", 5) == 0) {
            // start
            readptr = 0;
            lcd.cls();
                lcd.locate(0,0);
                lcd.printf("Dispositivo");
                lcd.locate(0,1);
                lcd.printf("Iniciado");
            pc.printf("Dispositivo Iniciado\n");
            rtc.startClock();          
            
        }
        else if (strncmp(buffer, "stop", 4) == 0) {
            //  stop
            pc.printf("Dispositivo detenido\n");
            rtc.stopClock();
        }
        else {
            pc.printf("syntax error\n");
        }
        readptr = 0;
        }

        set_prev: /// Función de verificación, se usa para confirmar la hora y  fecha del reloj y luego pasar a configurar la hora
        
        pc.printf("Es correcto? Si = 1  No = 2\n"); // se habilita esta opción para que el usuario 
        pc.scanf("%d", &Config);                           // verifique si la configuración ingresada es correcta o no
        
        if (Config == 2){                // Si se presiona 2, hubo errores en la configuración
            readptr = 0;
            goto set_reloj;             // se regresa a la función set_reloj para volver a configurar
            }
        
                  
        else if (Config == 1){           // se si presiona 1, la configuración fue correcta
             
             pc.printf("Dispositivo Configurado Correctamente  Espere ....\n"); // se espera un tiempo
             wait(3);
             goto set_alarma;           // y se va a la función correspondiente a la alarma
        }
        else {
            pc.printf("syntax error\n");
            goto set_prev;
        }
        //termina la función set_prev

        // Aquí se encuentra la función ALARMA, en la cual se configura los valores para la activación de esta
        set_alarma:             
        pc.printf("******* Configuracion Alarma *******\n");        
        
        set_dia: // Para que el usuario ingrese el día con el encoder
        while(1){
         
            dia=dia+wheel.getPulses();
            wheel.reset();
     
            if(dia>=31){        //En este if, se garantiza que los días esten entre 1 y 31
                dia=31;
            }
            else if (dia<=1){
             dia=1;
            }
            
     pc.printf(">Dia=%d    Mes=%d    Ano=%d    Hora=%d    Min=%d    Seg=%d\n ",dia,mes,ano,hh,mm,ss);
     wait(3);
     
    // A continuación se programan los botones del encoder para configurar con este las diferentes necesidades de la alarma
    
    if(BotonENC.falling()){ // Con el boton del encoder se pasa ingresar el siguiente dato necesario
        goto set_mes;
        }
    if(Boton2.falling()){ // Boton para aceptar la alarma y proceder a activarla
        goto set_comp;
    }
           
            
    }
        
        set_mes:
        while(1){
         
            mes=mes+wheel.getPulses();
            wheel.reset();
     
            if(mes>=12){                // Se garantiza que el valor del mes se encuentre entre los valores 1 y 12
                mes=12;
            }
            else if (mes<=1){
             mes=1;
            }
     pc.printf(" Dia=%d   >Mes=%d    Ano=%d    Hora=%d    Min=%d    Seg=%d\n ",dia,mes,ano,hh,mm,ss);
     wait(3);
    
    if(BotonENC.falling()){
        goto set_ano;
    }
    if(Boton2.falling()){ 
        goto set_comp;
    }           
            
    }
     set_ano:
        while(1){
         
            ano=ano+wheel.getPulses();
            wheel.reset();
     
            if(ano>=2100){              //Se programan alarmas para los próximos 84 años (entre los años 2016 y 2030)
                ano=2100;
            }
            else if (ano<=2016){
             ano=2016;
            }
     pc.printf(" Dia=%d    Mes=%d   >Ano=%d    Hora=%d    Min=%d    Seg=%d\n ",dia,mes,ano,hh,mm,ss);
     wait(3);    
    
    if(BotonENC.falling()){
        goto set_hh;
    }
    if(Boton2.falling()){
        goto set_comp;
    }      
           
    }
    set_hh:
        while(1){
         
            hh=hh+wheel.getPulses();
            wheel.reset();
     
            if(hh>=23){         // Las horas deben encontrarse siempre en el rango de 0 a 23 (La hora 24 = La hora 0)
                hh=23;
            }
            else if (hh<=0){
             hh=0;
            }
     pc.printf(" Dia=%d    Mes=%d    Ano=%d   >Hora=%d    Min=%d    Seg=%d\n ",dia,mes,ano,hh,mm,ss);
     wait(3);
    
    if(BotonENC.falling()){
        goto set_mm;
    }
    if(Boton2.falling()){
        goto set_comp;
    }           
            
    }
     set_mm:
        while(1){
         
            mm=mm+wheel.getPulses();
            wheel.reset();
     
            if(mm>=59){         //Minutos siempre positivos entre 0 y 59 (El minuto 60 es igual al 0)
                mm=59;
            }
            else if (mm<=0){
             mm=0;
            }
     pc.printf(" Dia=%d    Mes=%d    Ano=%d    Hora=%d   >Min=%d    Seg=%d\n ",dia,mes,ano,hh,mm,ss);
     wait(3);
    
    if(BotonENC.falling()){
        goto set_ss;
    }
    if(Boton2.falling()){
        goto set_comp;
    }          
            
    }
    
    set_ss:
        while(1){
         
            ss=ss+wheel.getPulses();
            wheel.reset();
            
            if(ss>=59){         //De nuevo, en un minuto hay 60 segundos ( partiendo del 0 al 59)
                ss=59;
            }
            else if (ss<=0){
             ss=0;
            }
     pc.printf(" Dia=%d    Mes=%d    Ano=%d    Hora=%d    Min=%d   >Seg=%d\n ",dia,mes,ano,hh,mm,ss);
     wait(3);
    
    if(BotonENC.falling()){
        goto set_dia;
    }
    if(Boton2.falling()){
        goto set_comp;
    }           
            
    }
    
    // Luego de tener totalmente ingresador los datos de la alarma, se ingresa a la sección donde se compara la fecha y hora actual con la fecha y hora de la alarma programada
    set_comp:
    
    pc.printf("***Datos ingresados para alarma****\n");
    pc.printf(" Dia=%d    Mes=%d    Ano=%d    Hora=%d    Min=%d    Seg=%d\n ",dia,mes,ano,hh,mm,ss);
    
    while(1){
       rtc.getTime(tm);
       pc.printf("El tiempo actual es : %02d:%02d:%02d\n", tm.hour, tm.min, tm.sec);
       pc.printf("La fecha actual es %s, %02d/%02d/%04d\n", rtc.weekdayToString(tm.wday), tm.mon, tm.date, tm.year);
       lcd.cls();
                lcd.locate(0,0);
                lcd.printf("%02d:%02d:%02d", tm.hour, tm.min, tm.sec);
                lcd.locate(0,1);
                lcd.printf("%s/%02d/%02d/%4d", rtc.weekdayToString(tm.wday), tm.date, tm.mon, tm.year);
                wait_ms(200);
    if(tm.hour>=hh && tm.min>=mm &&tm.sec>=ss && tm.mon>=mes && tm.date>=dia && tm.year>=ano){
     alarma1:
       
        myled=0;        // En estas líneas de código se busca mostrar el funcionamiento de la alarma cuando 
        myled2=1;       // esta es encendida mediante el encendido y apagado alternado de dos diodos leds.
        wait(0.5);      // con un pequeño tiempo de diferencia para lograr dicho efecto.
        myled=1;
        myled2=0;
        wait(0.5);
        
    if(BotonENC.falling()){ // Si la alarma esta activada y se presiona el boton del encoder se pasa a la función snooze 
            goto snooze;     
        }
    if(Boton2.falling()){ // Si la alarma esta activada y se presiona el boton externo se desactiva la alarma y ya solo muestra la hora
        myled=0;
        myled2=0;
        goto lop1;
    }
            
    }
    } 
     snooze:  // Se desactivan ambos leds representando que se detuvo la alarma 
        myled=0;
        myled2=0;   
        contador = contador+1; // El contador se usa para permitir que lafunción snooze solo se active 3 veces
        if (contador == 4){
            goto lop1; // Cuando se activa la cuarta vez, el boton del encoder la alarma se desactiva
            }
        wait(10); // Espera 10 segundos para volver a activar la alarma
        goto alarma1;
    }
