#include "mbed.h"
#include "TextLCD.h"
#include "Adafruit_Si4713.h"

TextLCD lcd(p19,p20,p21,p22,p23,p24);
AnalogIn Ain(p18);

InterruptIn decrease(p6);
InterruptIn increase(p7);
Timer debounce;

uint16_t fmstation=10740;

I2C myi2c(p9,p10);
Adafruit_Si4713 radio = Adafruit_Si4713(myi2c, p5, 0x63<<1);

void StationDown();
void StationUp();

void StationDown() {
if (debounce.read_ms()>200 && fmstation >= 8800) {
fmstation=fmstation-10;
radio.tuneFM(fmstation);
debounce.reset();
    }
}

void StationUp() {
if (debounce.read_ms()>200 && fmstation <= 10800) {
fmstation=fmstation+10;
radio.tuneFM(fmstation);
debounce.reset();
    }
}

int main() {

    printf("Adafruit Radio - Si4713 Test\r\n");
    
    if (! radio.begin()) {
        printf("Couldn't find radio?\r\n");
        while (1);
    }
    
    /*
    // Uncomment to scan power of entire range from 87.5 to 108.0 MHz
    for (uint16_t f  = 8750; f<10800; f+=10) {
        radio.readTuneMeasure(f);
        printf("Measuring %.1f\t",f/100.0);
        radio.readTuneStatus();
        printf("%i\r\n",radio.currNoiseLevel);
    }
    */
    
    printf("\n\rSet TX power");
    radio.setTXpower(115);  // dBuV, 88-115 max
    
        
    printf("\n\rTuning into %.1f\r\n",fmstation/100.0); 
    radio.tuneFM(fmstation);
    
    // This will tell you the status in case you want to read it from the chip
    radio.readTuneStatus();
    printf("\tCurr freq: %d\r\n", radio.currFreq); 
    printf("\tCurr freqdBuV: %d\r\n", radio.currdBuV); 
    printf("\tCurr ANTcap: %d\r\n", radio.currAntCap);
    
    debounce.start();
    decrease.rise(&StationDown);
    increase.rise(&StationUp);
            
    while(1) {
        lcd.cls();
        lcd.printf("FM STATION\n");
        lcd.printf("%1.1f MHz",fmstation/100.0);
        wait(0.25);
    }
    //printf("\n\rTuning into %.1f\r\n",fmstation/100.0);  
    
}

