#include "mbed.h"


void print_help() //help message
{   
printf("***********************************************************\r\n");
printf("* LEDON:x        - set time for LED to be ON              *\r\n");
printf("*                - x - time in seconds (range 1-1000)     *\r\n");
printf("*  LEDOFF        - turn LED off                           *\r\n");
printf("*  LEDSTATE      - print current LED state                *\r\n");
printf("*  BRIGHTSET:x   - set LED brightnes                      *\r\n");
printf("*                  x - range 0-7 (0 - low, 7 - high)      *\r\n");
printf("*  BRIGHTGET     - get LED brightnes                      *\r\n");
printf("*  BUTTONGET     - get user button monitorring state      *\r\n");
printf("*  BUTTONSTATE   - get user button state                  *\r\n");
printf("*  BUTTONENABLE  - enable button monitorring              *\r\n");
printf("*  BUTTONDISABLE - disable button monitorring             *\r\n");
printf("*  HELP          - print available list of commands       *\r\n");
printf("***********************************************************\r\n");   
}

void print_welcome() //welcome message
{
printf("\r\n"); 
printf("***********************************************************\r\n");
printf("*                                                         *\r\n");
printf("*                        WELCOME!                         *\r\n");
printf("*                                                         *\r\n");
printf("* To turn LED on for X seconds type:                      *\r\n");
printf("* LEDON:x     where [x] is specified period of seconds    *\r\n");
printf("*             x range 1-1000                              *\r\n");
printf("*                                                         *\r\n");
printf("***********************************************************\r\n");
}

void print_fc_off() //fault code message when LED is off
{
printf("WRONG INPUT\r\n"); 
printf(" To turn LED on type:   \r\n");
printf(" LEDON:x     where [x] is specified period of seconds    \r\n");
printf("             x range 1-1000                              \r\n");
}
    
void print_fc_on() //fault code message when LED is on
{
printf("WRONG INPUT\r\n"); 
printf(" To see available list of commands type HELP\r\n");
}    

//const
 int const LED_ON = 1;
 int const BRIGHT = 2;
 int const ON = 1;
 int const OFF = 0;
 int const B_ON = 0;
 int const B_OFF = 1;

//threads
Thread lamp_thread;
Thread timer_thread;

//variables
int print = 1;
char input [64];
int lamp_bright = 4;
bool lamp_state = false;
int lamp_time;
int state = OFF;
int b_state = OFF;
int b_push = B_OFF;

//interfaces
DigitalIn button(PC_13);
DigitalOut led2(LED1);
PwmOut led1(D11);

//pow
int power(int x, int n) {
    if(n == 0) return 1;
    return x * power(x, n - 1);
 }

// parse string and calculate input integer data
int strtoint(char instring[64], int slogan) 
{
    int str_len = strlen(instring);
    int result = 0;
    switch (slogan){
    case LED_ON: // "LEDON:"
      if (str_len > 10) return -2; // too long time
      for(int i = 6; i < str_len; i++) 
      {
        if(instring[i] > 47 && instring[i] < 58) // if input is digit
        {
          result = (result * 10) + instring[i] - 48;
        }
        else  // not a digit
        {
          result = -1;
          break;
          }
      }
      if (result > 1000) result = -2;
      break;
      
    case BRIGHT: //BRIGHTSET:
      if (str_len > 11) return -2; // too long time
      if(instring[10] > 55) return -2; // too long time
      if(instring[10] > 47 && instring[10] < 58) // if input is digit
        result = instring[10] - 48; 
      else  // not a digit
          result = -1;
      break;
    default:
      break;
    }
    return result;
}

//translate to CAPS
void caps()
{
    for(int i = 0; i < 63; i++) 
    {
      if(input[i] > 96 && input[i] < 123)
        input[i] = input[i] - 32;
    }
    printf("\r\n<%s\r\n",input);
}

//thread lamp, while led is off
void led_off()
{
        if (!strncmp (input,"LEDON:",6))
        {
          lamp_time = strtoint(input, LED_ON);
          switch (lamp_time){
            case 0:
            case -2: // wrong time time
              printf("WRONG TIME IS SPECIFIED. RANGE IS 1-1000\r\n");
              break;
          case -1:
              printf("PLEASE USE DIGITS FOR TIME SPECIFICATION.\r\n");
              break;
          default:
              printf("LED IS ON FOR %d SECONDS\r\n",lamp_time);
              led1 = power(2,lamp_bright) * 0.01;
              state = ON;
          }
        }
        else
        {
           print_fc_off();
        }
}

//thread lamp, while led is on
void led_on()
{
    if (!strcmp (input,"LEDOFF")) //turn led off
    {
        lamp_time = 1;
    }
    else if(!strcmp (input,"LEDSTATE")) //print LED state
    {
        printf("LED IS ON FOR %d SECONDS\r\n",lamp_time);
    }
    else if(!strncmp(input,"BRIGHTSET:",10)) //BRIGHTSET:x
    {
        int bright = strtoint(input, BRIGHT);
        switch (bright){
          case -2: // wrong brightness
              printf("WRONG BRIGHTNESS IS SPECIFIED. RANGE IS 0-7\r\n");
              break;
          case -1:
              printf("PLEASE USE DIGITS FOR BRIGHTNESS SPECIFICATION.\r\n");
              break;
          default:
              lamp_bright = bright;
              led1 = power(2,lamp_bright) * 0.01;
              printf("BRIGHTNESS IS SET TO %d\r\n",lamp_bright);
          }
    }
    else if(!strcmp (input,"BRIGHTGET")) //print brightness level
    {
        printf("BRIGHTNESS IS SET TO %d\r\n",lamp_bright);
    }
    else if(!strcmp (input,"BUTTONGET")) //print user button state
    {
        printf("BUTTON MONITORRING IS SET TO %s\r\n",b_state?"ON":"OFF");
    }
    else if(!strcmp (input,"BUTTONENABLE")) //enable button monitoring
    {
        b_state = ON;
        printf("BUTTON MONITORRING IS SET TO ON\r\n");
    }   
    else if(!strcmp (input,"BUTTONDISABLE")) //disable button monitoring
    {
        b_state = OFF;
        printf("BUTTON MONITORRING IS SET TO OFF\r\n");
    }  
    else if(!strcmp (input,"BUTTONSTATE")) //get button state
    {
        printf("BUTTON IS %sPUSHED\r\n",button?"NOT ":"");
    }  
    else if(!strcmp (input,"HELP")) //print help message
    {
        print_help();
    }
    else if (!strncmp (input,"LEDON:",6)) // reinit led timer
    {
        lamp_time = strtoint(input, LED_ON);
        switch (lamp_time){
        case 0:
        case -2: // wrong time time
            printf("WRONG TIME IS SPECIFIED. RANGE IS 1-1000\r\n");
            break;
        case -1:
            printf("PLEASE USE DIGITS FOR TIME SPECIFICATION.\r\n");
            break;
        default:
            printf("LED IS ON FOR %d SECONDS\r\n",lamp_time);
            led1 = power(2,lamp_bright) * 0.01;
            state = ON;
        }
    }
    else // wrong input
    {
        print_fc_on();
    }
}

//thread lamp, main function
void led()
{
    while (true)
    {
        scanf("%s",input);
        caps();
        switch (state){
        case OFF:
          led_off();
          break;
        case ON:
          led_on();
          break;
        default:
          break;
          }
     }
}

//thread timer, main function
void timer()
{
    while(true){
      while(state == ON)
      {
        lamp_time --;
        if (lamp_time == 0)
        {
          led1 = 0; 
          printf("LED IS TURNED OFF\r\n");
          lamp_thread.start(led_off);
          state = OFF;
          b_state = OFF;
        }
        wait(1);
      }
      wait(1);
    }
}

int main()
{
     print_welcome();
     lamp_thread.start(led);
     timer_thread.start(timer);

    while (true) {
        
        if (state == ON && b_state == ON)
        {
            if (button != b_push)
            {
              b_push = button;
              printf("BUTTON IS %sPUSHED\r\n",b_push?"NOT ":"");
            }
        }
        wait(0.2);
        
        }

}
