#include "mbed.h"
#include "SDFileSystem.h"
#include "EthernetInterface.h"
#include <iostream>
#include <fstream>
#include "DHT11.h"

#define NUMBER_OF_LINES     23
#define COLOR_LINE          12
#define TEMPERATURE_LINE    17
#define PRESSURE_LINE       18
#define HUMADITY_LINE       19
#define RAINFALL_LINE       20
#define TIME_LINE           21

SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); 
Serial pc(USBTX, USBRX);
string file_content[NUMBER_OF_LINES];


DHT11 d(PTD1);

void DHT11_read()
  {
      int s;
      s = d.readData();
      if (s != DHT11::OK) {
          pc.printf("Error!\r\n");
      }
      else {
          pc.printf("T:%d, H:%d\r\n", d.readTemperature(), d.readHumidity());
      }
  }


void initializeEthernet(void)
{
    EthernetInterface eth;
    const char *ip = "192.168.1.3";
    const char *mask = "255.255.255.0";
    const char *gateway = "192.168.1.1";
    if(!eth.init(ip,mask,gateway))
    {   
        pc.printf("Ethernet card initialized successfully.\r");
        eth.connect();        
        pc.printf("IP address: %s\n",eth.getIPAddress());
        pc.printf("Network mask: %s\n",eth.getNetworkMask());
        pc.printf("Gateway: %s\n",eth.getGateway());
        pc.printf("MAC address: %s\n",eth.getMACAddress());
    }
    else
        pc.printf("Ethernet card could not be initialized.\r");    
    return; 
}

void readHTMLCode(void)
{
    fstream file;    
    int cnt = 0;
    for (int i = 0; i < NUMBER_OF_LINES; i++)
        file_content[i] = " ";
    file.open("/sd/index.html", ios::in);
    if (file.good())
    {
        pc.printf("The index.html file has been opened. \r");
        while(!file.eof())
        {
            getline(file,file_content[cnt]);
            pc.printf("cnt: %i \n \r", cnt);
            cnt++;           
        }
        file.close();
        pc.printf("The file has been closed. \r");
    }
    else
    {
        pc.printf("The file could not be opened. \r");
        return;
    }
}

void initializeSerialPC(void)
{
    pc.baud(115200);
    pc.printf("Serial port initialized. \r");
}

int main() 
{

    initializeSerialPC();
    //DHT11_read(); 
    readHTMLCode();  
    initializeEthernet(); 

    while(1);
}
