//--- Includes
#include "mbed.h"

//--- Defines
#define     USB_UART        1
#define     ON              1
#define     OFF             0
#define     BAUDRATE0       19200
#define     BAUDRATE1       115200
#define     K_BACKSPACE     8
#define     K_RETURN        13

//--- Objects
DigitalOut  myled       (LED1);
#if USB_UART
    Serial      myUART      ( USBTX, USBRX );      
#else
    Serial      myUART      ( p13, p14 );   //--- TX    RX
#endif
Serial      loopUART    ( p28, p27 );   //--- TX    RX

int main() {
    char    character;
        
    //--- init
    myled = ON;
    wait(0.2);
    myUART.baud( BAUDRATE1 );
    loopUART.baud( BAUDRATE1 );
    myled = OFF;
    
    while(1) {
        //--- Read myUART and print to loopUART
        if( myUART.readable() ) {
            character = myUART.getc();
            loopUART.printf( "%c", character );
        }
        
        //--- Read loopUART and print to myUART
        if( loopUART.readable() ) {
            character = loopUART.getc();
            
            //--- Return Key: new line on the console
            if( character == K_RETURN ) {
                myUART.printf("\n\r");
            } else if( character == K_BACKSPACE ) {
                myUART.printf("\b \b");
            } else {
                myUART.printf( "%c", character );
            }
        }
        
        /*
            //--- Loopback the UART
            if( myUART.readable() ) {
                myUART.putc( myUART.getc() );
            }
        */
        
        /*
            //--- Hello World on the UART
            myUART.printf( "Hello, world!\n\r" );
        */
    }
}
