#include "mbed.h"
#include "keypad.h"

// Define your own keypad values
char Keytable[] = { '1', '2', '3', 'A',
                    '4', '5', '6', 'B',
                    '7', '8', '9', 'C',
                    '*', '0', '#', 'D'
                  };

BusOut code(LED4, LED3, LED2, LED1); //show binary code of key

uint32_t cbAfterInput(uint32_t key)
{
    printf("Key: %d => \'%c\'\n", key, Keytable[key]);
    code = key;

    return 0;
}

uint32_t cbAfterMultipleInput(uint32_t key)
{
    for (int i = 0; i < 16; i++) {
        if (key & (1 << i)) {
             printf("Key: %d => \'%c\'\t", i, Keytable[i]);
        }
    }
    printf("\n");
    code = key;

    return 0;
}

void Sleep(void)
{
    __WFI();
}

int main()
{
    printf("*** Keypad Demo ***\n");

    Keypad keypad(p25, p26, p27, p28, p21, p22, p23, p24);

// interrupt mode
/*
    keypad.CallAfterInput(&cbAfterInput);
    keypad.Start();
    while (1) {
        Sleep();
    }
*/
    
// polling mode
/*
    keypad.Start();
    while (1) {
        int key = keypad.DebouncedScan();
        if (key >= 0)
            cbAfterInput(key);
        wait(0.1);
    }
*/

// poll multiple mode
    keypad.Start();
    while (1) {
        int key = keypad.DebouncedScanMultiple();
        if (key > 0)
            cbAfterMultipleInput(key);
        wait(0.1);
    }
}