/*
LedShow

This demo shows: 
- how to write to the multiple outputs/leds using a bus
- how to send (debug) info to the pc
- how to persist values

 */

#include "mbed.h"

BusOut leds(LED1, LED2, LED3, LED4);
Serial pc(USBTX, USBRX);
LocalFileSystem local("local");

#define delay 0.25
typedef struct {
    int value;
    int steps;
} show;
show shows[] = {{1, 4}, {3, 3}, {7, 2}, {5, 2}, {15, 5}};
char *show_file = "/local/show.txt";
char *format = "%d\n";

int main()
{
    pc.printf("*** The Ultimate Led Show ***\n");

    int show_index = 0;

    FILE *fp = fopen(show_file, "r");
    if (fp) {
        fscanf(fp, format, &show_index);
        fclose(fp);
    }

    fp = fopen(show_file, "w");
    if (fp) {
        fprintf(fp, format, (show_index + 1) % (sizeof(shows) / sizeof(show)));
        fclose(fp);
    }

    pc.printf("Show %d out of %d.\n", show_index + 1, (sizeof(shows) / sizeof(show)));
    pc.printf("Press the reset button to move to the next one.\n");

    show current = shows[show_index];

    int step = 0;
    bool step_forward = true;
    while(1) {
        leds = current.value << step;
        wait(delay);

        if (step == 0)
            step_forward = true;
        else if (step == current.steps - 1)
            step_forward = false;

        if (step_forward)
            step++;
        else
            step--;
    }
}
