#include "mbed.h"

Ticker flipper;
PwmOut mypwm(LED1);
DigitalIn sw(USER_BUTTON);

bool flip_flag;

void flip()
{
    flip_flag = 1;
}

void eg_func(double &eg,int &eg_status,int note,double late,double attack,double decay,double sustain,double release)
{
    if(note == 0) {
        if(eg > 0)  eg -= late / release;
        else eg = 0;
        eg_status = 0;
    } else {
        if(eg_status == 0) {
            if(eg < 1)  eg += late / attack;
            else {
                eg = 1;
                eg_status = 1;
            }
        } else {
            if(eg > sustain)  eg -= (1 - sustain) * late / decay;
            else    eg = sustain;
        }
    }
}


int main()
{
    double eg,late,attack,decay,sustain,release;
    int eg_status,note;
    
    late = 0.00002;
    
    attack = 0.2;
    decay = 0.2;
    sustain = 0.2;
    release = 0.5;
    
    mypwm.period_us(20);
    flipper.attach_us(&flip,20);
    
    while(1) {
        //button status
        if(sw == 0) note = 1;
        else note = 0;
        
        if(flip_flag == 1) {

            eg_func(eg,eg_status,note,late,attack,decay,sustain,release); 
            mypwm.write(eg);

            flip_flag = 0;
        }
    }
}
