#include "mbed.h"
#include "BME280.h"

Serial pc(SERIAL_TX, SERIAL_RX);

#if defined(TARGET_LPC1768)
BME280 sensor(p28, p27);
#else
BME280 sensor(I2C_SDA, I2C_SCL);
#endif

static double t0,p0;

void altitude_setup()
{
    t0 = sensor.getTemperature();
    p0 = sensor.getPressure();

}

double altitude_calc()
{
    double altitude;

    altitude = ((pow( p0 / sensor.getPressure() , 1 / 5.257) - 1) * (t0 + 273.15) ) / 0.0065;

    return altitude;
}


int main()
{

    float altitude;

    altitude_setup();


    while(1) {

        altitude = altitude_calc();

        pc.printf("%.1nlf\n\r",altitude);
        pc.printf("%2.2f degC, %04.2f hPa, %2.2f %%\n\r", sensor.getTemperature(), sensor.getPressure(), sensor.getHumidity());

        wait(0.2);

    }
}
