#include "mbed.h"

Ticker flipper;
PwmOut mypwm(PC_8);
DigitalIn sw(USER_BUTTON);


//duty must input 0.1-0.9
bool flip_flag;

void flip()
{
    flip_flag = 1;
}

double sin_osc(double late,double freq_out,double &ift)
{
    double data;

    data = sin(6.28 * ift);

    ift += late * freq_out;
    if(ift > 1)    ift--;

    return data;
}
double square_osc(double late,double freq_out,double duty,double &ift)
{
    double data;

    if(duty > ift)  data = 1;
    else data = -1;

    ift += late * freq_out;
    if(ift > 1)    ift--;

    return data;
}
double triangle_osc(double late,double freq_out,double duty,double &ift)
{
    double data;
    
    if(ift < duty)    data = 2 * (ift * (1 / ift) - 0.5);
    else    data = 2 *( (1 / (1 - duty)) * (1 - ift) - 0.5);

    ift += late * freq_out;
    if(ift > 1)    ift--;

    return data;
}

int main()
{
    double data,late,ift_1,ift_2;
    late = 20 * 0.001 * 0.001;

    mypwm.period_us(20);
    flipper.attach_us(&flip,20);

    while(1) {

        if(flip_flag == 1) {

            data = (sin_osc(late,1200,ift_1) * sin_osc(late,1210,ift_2)) + 1;
            mypwm.write( data / 20 );

            flip_flag = 0;
        }
    }
}
