/**
 * @file main.c
 * @brief ATM0177B3A(ILI9163 128x160) TFT LCD Test code
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Gitakichi
 * @author Jun Morita (iccraft)
 *
 * @copyright   Copyright (C) 2012 Simon Inns
 * @author Simon Inns <simon.inns@gmail.com>
 */

#include "mbed.h"
#include "ili9163lcd.h"

//const bool shehuizhuyi[] = {};


DigitalOut LED(LED1);

int main()
{
    uint8_t tm=10;
    uint8_t R=0,G=0,B=0;
    uint8_t RGB_state=0;
    
    //lcdInitialise(LCD_ORIENTATION3);
    lcdInitialise(ROT_BOTTOM);
    
    //lcdWriteData_monoburst((bool*)shehuizhuyi,20480);
    //wait(5);
    
    lcdClearDisplay(decodeRgbValue(31, 31, 10));
    
    uint16_t chr_fu[]={
        0x0100,0x0100,0x7ffe,0x4002,0x5ffa,0x0000,0x0ff0,0x0810,0x0ff0,0x0000,0x1ff8,0x1108,0x1ff8,0x1108,0x1ff8,0x0000};
    uint16_t chr_qiang[]={
        0x0000,0x7CF8,0x0488,0x0488,0x04F8,0x3C20,0x21FC,0x2124,0x3D24,0x0524,0x05FC,0x0520,0x0422,0x043E,0x0BC1,0x3001};
    uint16_t chr_min[]={
        0x0000,0x1ffc,0x1004,0x1004,0x1004,0x1ffc,0x1080,0x1080,0x1fff,0x1040,0x1040,0x1020,0x1020,0x1312,0x1c0a,0x6006};
    uint16_t chr_zhu[]={
        0x0100,0x0080,0x0080,0x3ffe,0x0080,0x0080,0x0080,0x0080,0x1ffc,0x0080,0x0080,0x0080,0x0080,0x0080,0x7fff,0x0000};
    uint16_t chr_wen[]={
        0x0100,0x0600,0x3c7e,0x0442,0x0442,0x0442,0x7fc2,0x0c42,0x0e42,0x1542,0x14c2,0x2442,0x447e,0x0400,0x0400,0x0400};
    uint16_t chr_ming[]={
        0x0108,0x2109,0x11EA,0x090C,0x0109,0x7169,0x1187,0x1010,0x1020,0x11FE,0x1102,0x11FE,0x1502,0x1902,0x31FE,0x0102};
    uint16_t chr_he[]={
        0x0080,0x0080,0x0080,0x7fff,0x0410,0x0410,0x0410,0x0220,0x0220,0x0140,0x0080,0x0080,0x0140,0x0220,0x0c18,0x7007};
    uint16_t chr_xie[]={
        0x0000,0x3e7e,0x2242,0x2242,0x2242,0x227e,0x3e42,0x2242,0x2242,0x227e,0x2242,0x3e42,0x0082,0x0082,0x0102,0x0206};

    
    lcdPutCh_16(chr_fu,0, 0, decodeRgbValue(31, 0, 0), decodeRgbValue(31, 31, 10));
    lcdPutCh_16(chr_qiang,32, 0, decodeRgbValue(31, 0, 0), decodeRgbValue(31, 31, 10));
    lcdPutCh_16(chr_min,64, 0, decodeRgbValue(31, 0, 0), decodeRgbValue(31, 31, 10));
    lcdPutCh_16(chr_zhu,96, 0, decodeRgbValue(31, 0, 0), decodeRgbValue(31, 31, 10));
    
    lcdPutCh_16(chr_wen,0, 32, decodeRgbValue(31, 0, 0), decodeRgbValue(31, 31, 10));
    lcdPutCh_16(chr_ming,32, 32, decodeRgbValue(31, 0, 0), decodeRgbValue(31, 31, 10));
    lcdPutCh_16(chr_he,64, 32, decodeRgbValue(31, 0, 0), decodeRgbValue(31, 31, 10));
    lcdPutCh_16(chr_xie,96, 32, decodeRgbValue(31, 0, 0), decodeRgbValue(31, 31, 10));
    wait(2);
    
    grade();
    wait(2);
    
    colorbar();
    wait(10);
    
    lcdClearDisplay(decodeRgbValue(0, 0, 0));
     
    lcdLine(0, 0, 127, 127, decodeRgbValue(31, 31, 31));
    lcdLine(0, 127, 127, 0, decodeRgbValue(31, 31, 31));
    lcdCircle(64, 64, 32, decodeRgbValue(31, 0, 0));
    lcdCircle(64, 64, 40, decodeRgbValue(0, 31, 0));
    lcdCircle(64, 64, 48, decodeRgbValue(0, 0, 31));
    
    lcdPutS("Hello World!", lcdTextX(4), lcdTextY(0), decodeRgbValue(0, 0, 0), decodeRgbValue(31, 31, 31));
    
    lcdPutS("The quick brown fox jumped over the lazy dog 0123456789", lcdTextX(0), lcdTextY(2), decodeRgbValue(0, 31, 31), decodeRgbValue(0, 0, 0));
    
    lcdFilledRectangle(0, 64, 127, 127, decodeRgbValue(0, 0, 0));
    lcdRectangle(0, 64, 127, 127, decodeRgbValue(31, 31, 31));
    
    // Run the LCD test
    uint8_t ballX = 64, ballY = 96;
    int8_t ballSpeed = 1;
    int8_t xDir = ballSpeed, yDir = ballSpeed;
    
    
    // Bouncy ball demo
    while(1)
    {
        // Delete the ball
        lcdFilledRectangle(ballX-2, ballY-1, ballX+2, ballY+1, decodeRgbValue(0, 0, 0));
        
        // Delete the bat
        lcdFilledRectangle(ballX-4, 121, ballX+4, 123, decodeRgbValue(0, 0, 0));
        
        // Move the ball
        ballX += xDir;
        ballY += yDir;
        
        // Range check
        if (ballX > 120) xDir = -ballSpeed;
        if (ballX < 7) xDir = ballSpeed;
        
        if (ballY > 120) yDir = -ballSpeed;
        if (ballY < 70) yDir = ballSpeed;
        
        // Plot the ball
        lcdFilledRectangle(ballX-2, ballY-1, ballX+2, ballY+1, decodeRgbValue(31, 31, 31));
        
        // Plot the bat
        lcdFilledRectangle(ballX-4, 121, ballX+4, 123, decodeRgbValue(31, 0, 31));
        
//        lcdPutS("Hello World!", lcdTextX(4), lcdTextY(0), decodeRgbValue(0, 0, 0), decodeRgbValue(31, 31, 31));
        lcdPutS("Hello World!", lcdTextX(4), lcdTextY(0), decodeRgbValue(0, 0, 0), decodeRgbValue(R, G, B));
        switch (RGB_state){
            case 0:
                if(++R >= 31)RGB_state++;
                break;
            case 1:
                if(--R == 0)RGB_state++;
                break;
            case 2:
                if(++G >= 31)RGB_state++;
                break;
            case 3:
                if(--G == 0)RGB_state++;
                break;
            case 4:
                if(++B >= 31)RGB_state++;
                break;
            case 5:
                if(--B == 0)RGB_state++;
                break;
            case 6:
                if(++R >= 31)RGB_state++;
                B = R;
                break;
            case 7:
                if(-- R== 0)RGB_state++;
                B = R;
                break;
            case 8:
                if(++R >= 31)RGB_state++;
                G = R;
                break;
            case 9:
                if(-- R== 0)RGB_state++;
                G = R;
                break;
            case 10:
                if(++G >= 31)RGB_state++;
                B = G;
                break;
            case 11:
                if(-- G== 0)RGB_state++;
                B = G;
                break;
            case 12:
                if(++R >= 31)RGB_state++;
                B = G = R;
                break;
            case 13:
                if(--R == 0)RGB_state = 0;
                B = G = R;
                break;
        }
        wait_ms(10);
        if(--tm==0){
            tm=10;
            LED = LED ^ 1;
        }
    }
    
}
