// Copyright (c) 2010 mwaddilove
// Released under the MIT License: http://mbed.org/license/mit

#include "TextLCD_Serial.h"

//! Constructor
TextLCD_Serial::TextLCD_Serial(PinName tx, PinName rx, char const * name /*= NULL*/)
    : _lcd(tx, rx) 
{
    _lcd.baud(9600);
}
    
    
 void TextLCD_Serial::character(int column, int row, int c)
 {
    setLCDCursor(column, row);
    
    writeData(c);
 }
 

//! Set the LCD's cursor position
void TextLCD_Serial::setLCDCursor(int const column, int const row)
{
    unsigned char const positionCode = Codes::Position | ((row & 0x1) << 6) | (column % 0x3F);
    
    writeCommand(positionCode);
}

/** Clear the screen and locate to 0,0 */
void TextLCD_Serial::cls()
{
    writeCommand(Codes::Clear);
    
    locate(0,0);
}


//! write a byte to _lcd
void TextLCD_Serial::writeByte(int const value)
{
    _lcd.putc(value);
}


//!Send a command
void TextLCD_Serial::writeCommand(int const command)
{
    writeByte(Codes::Command);
    writeByte(command);
}


//! write a regular char.
void TextLCD_Serial::writeData(int const data)
{
    writeByte(data);
}
