// Copyright (c) 2010 mwaddilove
// Released under the MIT License: http://mbed.org/license/mit

#pragma once

#include "TextDisplay.h"

//! class that implements TextDisplay, for a 2x16 (2x20 etc. to come) serial LCD, controlled by the HD44780
class TextLCD_Serial : public TextDisplay
{
public:
    //! Constructor
    TextLCD_Serial(PinName tx, PinName rx, char const * name = NULL);
    
    virtual void character(int column, int row, int c);
    
    virtual int rows() 
    {
        return 2;
    }
    virtual int columns()
    {
        return 16;
    }
 
    /** Clear the screen and locate to 0,0 */
    virtual void cls();

    
protected:
    //! Set the LCD's cursor position
    void setLCDCursor(int const column, int const row);

    //! write a byte to _lcd
    void writeByte(int const value);
    //!Send a command
    void writeCommand(int const command);
    //! write a regular char.
    void writeData(int const data);

    //! Enum with command codes.
    struct Codes
    {
        enum Enum
        {
            BackLight   = 0x7C,
            Command     = 0xFE,
            Clear       = 0x01,
            DisplayOn   = 0x0C,
            DisplayOff  = 0x08,
            UnderlineCursorOn  = 0x0E,
            UnderlineCursorOff = 0x0C,
            BlinkingCursorOn   = 0x0D,
            BlinkingCursorOff  = 0x0C,
            CursorLeft  = 0x10,
            CursorRight = 0x14,
            ScrollLeft  = 0x18,
            ScrollRight = 0x1C,
            
            Position    = 0x80
        };
    };

    Serial _lcd;
};
