#pragma once

//! class that implements an interface like TextLCD, for a serial LCD :)
class SerialLCD : public Serial
{
public:
    //! Constructor
    SerialLCD(PinName tx, PinName rx)
        : Serial(tx, rx) 
    {
        baud(9600);
    }
    
    //! Enum with command codes.
    struct Codes
    {
        enum Enum
        {
            BackLight   = 0x7C,
            Command     = 0xFE,
            Clear       = 0x01,
            DisplayOn   = 0x0C,
            DisplayOff  = 0x08,
            UnderlineCursorOn  = 0x0E,
            UnderlineCursorOff = 0x0C,
            BlinkingCursorOn   = 0x0D,
            BlinkingCursorOff  = 0x0C,
            CursorLeft  = 0x10,
            CursorRight = 0x14,
            ScrollLeft  = 0x18,
            ScrollRight = 0x1C,
            
            Position    = 0x80,
            
        };
    };

    /** Locate to a screen column and row
    *
    * @param column  The horizontal position from the left, indexed from 0
    * @param row     The vertical position from the top, indexed from 0
    */
    void locate(int column, int row)
    {
        unsigned char const code = Codes::Position | ((row & 0x1) << 6) | (column % 0x3F);
        
        send_command(code);
    }
 
    /** Clear the screen and locate to 0,0 */
    void cls()
    {
        send_command(Codes::Clear);
        
        locate(0,0);
    }
    
    //!Send a command
    void send_command(int const command_code)
    {
        putc(Codes::Command);
        putc(command_code);
    }
};
