#include "mbed.h"
#include "MQTTEthernet.h"
#include "MQTTClient.h"

DigitalOut myled(LED1);

int arrivedcount = 0;
 
 
void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
   
    printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\n", message.qos, message.retained, message.dup, message.id);
    printf("Payload %.*s\n", message.payloadlen, (char*)message.payload);
    ++arrivedcount;
   
}
 
int main(int argc, char* argv[]) {
    
    MQTTEthernet ipstack = MQTTEthernet();
    float version = 0.47;
    char* topic = "tet";
 
    MQTT::Client<MQTTEthernet,Countdown> client = MQTT::Client<MQTTEthernet,Countdown>(ipstack);
    
    char* hostname = "nisgvm1.pune.cdac.in";
    int port = 1883;
    
    
    int rc = ipstack.connect(hostname, port);
    if (rc != 0)
        myled = 1;
 
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;       
    data.MQTTVersion = 3;
    data.clientID.cstring = "mbed-sample";
    
    if ((rc = client.connect(&data)) != 0)
        myled = 2;
        //lcd.printf("rc from MQTT connect is %d\n", rc);
    
    if ((rc = client.subscribe(topic, MQTT::QOS1, messageArrived)) != 0)
        myled = 0;
        //lcd.printf("rc from MQTT subscribe is %d\n", rc);
 
    MQTT::Message message;
 
    // QoS 0
    char buf[100];
    sprintf(buf, "Hello World!  QoS 0 message from app version %f\n", version);
    message.qos = MQTT::QOS0;
    message.retained = false;
    message.dup = false;
    message.payload = (void*)buf;
    message.payloadlen = strlen(buf)+1;
    rc = client.publish(topic, &message);
    while (arrivedcount < 1)
        client.yield(100);
        
    // QoS 1
    sprintf(buf, "Hello World!  QoS 1 message from app version %f\n", version);
    message.qos = MQTT::QOS1;
    message.payloadlen = strlen(buf)+1;
    rc = client.publish(topic, &message);
    while (arrivedcount < 2)
        client.yield(100);
        
    // QoS 2
    sprintf(buf, "Hello World!  QoS 2 message from app version %f\n", version);
    message.qos = MQTT::QOS2;
    message.payloadlen = strlen(buf)+1;
    rc = client.publish(topic, &message);
    while (arrivedcount < 3)
        client.yield(100);
        
    // n * QoS 2
    for (int i = 1; i <= 10; ++i)
    {
        sprintf(buf, "Hello World!  QoS 2 message number %d from app version %f\n", i, version);
        message.qos = MQTT::QOS2;
        message.payloadlen = strlen(buf)+1;
        rc = client.publish(topic, &message);
        while (arrivedcount < i + 3)
            client.yield(100);
    }
    
    if ((rc = client.unsubscribe(topic)) != 0)
        printf("rc from unsubscribe was %d\n", rc);
    
    if ((rc = client.disconnect()) != 0)
        printf("rc from disconnect was %d\n", rc);
    
    ipstack.disconnect();
    
   // lcd.cls();
    //lcd.locate(0,3);
   // lcd.printf("Version %.2f: finish %d msgs\n", version, arrivedcount);
    printf("Finishing with %d messages received\n", arrivedcount);
    
    return 0;    
}
