#include "GPS.h"

GPS::GPS(PinName tx, PinName rx) : _gps(tx, rx) {
    //_gps.baud(38400);
    _gps.baud(9600);
    //_gps.baud(4800);
    //_gps.printf("$PSRF103,2,0,0,1*26\r\n");
    //_gps.printf("$PSRF103,3,0,0,1*27\r\n");
    //_gps.printf("$PSRF103,4,0,0,1*20\r\n");
    flag_gps_get = 0;
    flag_gps_getend = 0;
    _gps.attach(this,&GPS::sample,Serial::RxIrq);
    count = 0;
    flag_gga = 0;
}

void GPS::sample() {
    getline();
    if(flag_gps_getend){
        if(sscanf(msg, "$GPGGA,%f,%f,%c,%f,%c,%d", &_time, &_latitude, &_ns, &_longitude, &_ew, &_lock) >= 1) {
            flag_gga = 1;
            strcpy(gga,msg);
            float degrees = floor(_latitude / 100.0f);
            float minutes = _latitude - (degrees * 100.0f);
            _latitude = degrees + minutes / 60.0f;
            degrees = floor(_longitude / 100.0f);
            minutes = _longitude - (degrees * 100.0f);
            _longitude = degrees + minutes /60.0f;
        }
        flag_gps_getend = 0;
    }
}

char* GPS::getGGA(){
    if(flag_gga){
//        strcpy(gga,msg);
        flag_gga = 0;
    }
    return gga;
}

float GPS::longitude(){
    return _longitude;
}

float GPS::latitude(){
    return _latitude;
}

float GPS::time(){
    return _time;
}

int GPS::ns(){
    int d;
    if(_ns == 'N'){
        d = 1;
    }else{
        d = -1;
    }
    return d;
}

int GPS::ew(){
    int d;
    if(_ew == 'E'){
        d = 1;
    }else{
        d = -1;
    }
    return d;
}

int GPS::lock(){
    return _lock;
}

void GPS::getline() {
    char temp;
    temp = _gps.getc();
    if(temp == '$'){
        flag_gps_get = 1;
        count = 0;
    }
    if(flag_gps_get){
        msg[count] = temp;
        if(temp == '\r'){
            msg[count] = '\0';
            flag_gps_getend = 1;
            flag_gps_get = 0;
        }
        count ++;
    }
}