/*
 * "Node" Device
 * "Universe" 512 DMX datas
 * "Sub-Net" 16 Universe
 * "Server" Controller
 *
 * can use over 40 Sub-Net on network.
 */

#include "mbed.h"
#include "EthernetNetIf.h"
#include "DmxArtNet.h"
#include "DMX.h"


#define LED_NET_ACT_ON led_yk = 0
#define LED_NET_ACT_OFF led_yk = 1
#define LED_NET_G_ON led_gayk = 1; led_gkya = 0
#define LED_NET_Y_ON led_gayk = 0; led_gkya = 1
#define LED_NET_GY_OFF led_gayk = 0; led_gkya = 0

extern "C" void mbed_mac_address(char *s);

DigitalOut led_red(p22), led_yellow(p23);
DigitalOut led_gayk(p24),led_gkya(p25), led_yk(p26);
DigitalIn eth_link(P1_25), eth_speed(P1_26);
DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);
EthernetNetIf *eth;
DmxArtNet art;
//DMX dmx1(p13, p14);
//DMX dmx2(p28, p27);
Serial pc(USBTX, USBRX);

SPI spi(p11, p12, p13); // mosi, miso, sclk

void no_memory () {
    printf("panic: can't allocate to memory!\r\n");
    exit(-1);
}

void shutdown () {
   art.ArtPollReply.NumPorts = 0;
   strcpy(art.ArtPollReply.NodeReport, "Shutdown");
   art.SendArtPollReply();
   art.Done();
}

void PutLed(unsigned long GRB)
{    
    int SpiPack = 0;
    int c = 0;
    int i;
    for(i = 0; i < 24; i++)
    {
        if(GRB & ((long)(1) << (23-i)))
            SpiPack += 6;
           else
            SpiPack += 4;
        
        if(c++ >= 3)
        {
        
            // First don't write to the FIFO buffer if it is full
    while (!(LPC_SSP0->SR & 2))   // While TNF-Bit = 0 (FIFO full)...
        ;                           // Wait
    LPC_SSP0->DR = SpiPack;            // Write to FIFO buffer
           
           
       //     spi.write(SpiPack);
            SpiPack = 0;
            c = 0;  
        }
        
        SpiPack = SpiPack << 3;
    
    }
}


int main () {
    int i, u;
    char mac[6];
    IpAddr ip;
    EthernetErr ethErr;
    
    uint32_t PixIn;

    spi.format(12,0); //4 bit alla volta
    //spi.frequency(1000000);
   spi.frequency(3125000);
   
/*
unsigned long j = 0;    
while(1){
    PutLed(0x000055);
    PutLed(0x005500);
    PutLed(0x550000);
    PutLed(j+10);
    PutLed(j+10);
    PutLed(j+10);
    PutLed(j+10);
    j+=10;
    wait_ms(1);
    
    //wait_ms(25);
};
*/

    set_new_handler(no_memory); // new handler function

    pc.baud(112500);

    eth_link.mode(PullUp);
    eth_speed.mode(PullUp);

    if (! eth_link) {
        LED_NET_G_ON;
    }
    LED_NET_ACT_ON;

    mbed_mac_address(mac);
    ip = IpAddr(2, mac[3], mac[4], mac[5]);
    eth = new EthernetNetIf(ip, IpAddr(255,0,0,0), IpAddr(0,0,0,0), IpAddr(0,0,0,0));
    ethErr = eth->setup();
    if (ethErr) {
        LED_NET_Y_ON;
        led_red = 1;
        return -1;
    }
    pc.printf("Bind to interface: %d.%d.%d.%d\r\n", (unsigned char)ip[0], (unsigned char)ip[1], (unsigned char)ip[2], (unsigned char)ip[3]);

    art.BindIpAddress = ip;
    art.BCastAddress = IpAddr(2,255,255,255);

    art.InitArtPollReplyDefaults();
    // Device
    art.ArtPollReply.PortType[0] = 128; // output
    art.ArtPollReply.PortType[1] = 128; // output
    art.ArtPollReply.PortType[2] = 64; // input
    art.ArtPollReply.GoodInput[2] = 4;
    art.ArtPollReply.PortType[3] = 64; // input
    art.ArtPollReply.GoodInput[3] = 4;

    art.Init();
    art.SendArtPollReply(); // announce to art-net nodes

    while (1) {
        Net::poll();
        if (! eth_link) {
            LED_NET_G_ON;
        } else {
            LED_NET_GY_OFF;
        }
        
        if (art.Work()) {
            u = art.LastRecievedUniverse;
            if(u == 0){
                led1 = 1;
               for(i = 0; i < 510; i += 3)
               {
                   PixIn =  art.DmxIn[u][i+1];
                   PixIn <<= 8;
                   PixIn +=  art.DmxIn[u][i];
                   PixIn <<= 8;
                   PixIn +=  art.DmxIn[u][i+2];
                   PutLed(PixIn);
               }
               wait_us(25);
               wait_us(25);
               wait_us(25);
               wait_us(25);
               led1 = 0;
            }
            pc.printf("recv, node %d, data %x %x %x\r\n", u, art.DmxIn[u][0], art.DmxIn[u][1], art.DmxIn[u][2]);
            /*if (u == 0) {
                led1 = 1;
                for (i = 0; i < 512; i ++) {
                    dmx1.put(i, art.DmxIn[u][i]);
                }
            } else
            if (u == 1) {
                led2 = 1;
                for (i = 0; i < 512; i ++) {
                    dmx2.put(i, art.DmxIn[u][i]);
                }
            }*/
//            pc.printf("recv, node %d, data %d\r\n", u, art.DmxIn[u][0]);
         }
        
        
        /*if (art.Work()) {
            LED_NET_ACT_ON;
            led_yellow = 1;
            u = art.LastRecievedUniverse;
            if (u == 0) {
                led1 = 1;
                for (i = 0; i < 512; i ++) {
                    dmx1.put(i, art.DmxIn[u][i]);
                }
            } else
            if (u == 1) {
                led2 = 1;
                for (i = 0; i < 512; i ++) {
                    dmx2.put(i, art.DmxIn[u][i]);
                }
            }
            pc.printf("recv, node %d, data %d\r\n", u, art.DmxIn[u][0]);
            led1 = 0;
            led2 = 0;
            led_yellow = 0;
        }*/
        
        /*if (dmx1.is_recived) {
            led3 = 1;
            led_yellow = 1;
            dmx1.is_recived = 0;
            u = 0;
            for (i = 0; i < 512; i ++) {
                art.DmxIn[u][i] = dmx1.get(i);
            }
            LED_NET_ACT_ON;
            art.ArtPollReply.GoodInput[u] = 128;
            art.Send_ArtDmx(u, 0, (char*)art.DmxIn[u], 512);
            pc.printf("send, node %d, data %d\r\n", u, art.DmxIn[u][0]);
            led3 = 0;
            led_yellow = 0;
        }

        if (dmx2.is_recived) {
            led4 = 1;
            led_yellow = 1;
            dmx2.is_recived = 0;
            u = 1;
            for (i = 0; i < 512; i ++) {
                art.DmxIn[u][i] = dmx2.get(i);
            }
            LED_NET_ACT_ON;
            art.ArtPollReply.GoodInput[u] = 128;
            art.Send_ArtDmx(u, 0, (char*)art.DmxIn[u], 512);
            pc.printf("send, node %d, data %d\r\n", u, art.DmxIn[u][0]);
            led4 = 0;
            led_yellow = 0;
        }

        LED_NET_ACT_OFF;*/
    }
}

