#include "ds3231.h"

//--------------------------Puertos---------------------------------//
Ds3231 rtc(PTE0, PTE1); //rtc object Ds3231::Ds3231(PinName sda, PinName scl) : I2C(sda, scl)

//----------------------Funciones--------------------------------//
void get_user_input(char* message, uint8_t min, uint8_t max, uint32_t* member);
void get_user_input(char* message, uint8_t min, uint8_t max, bool* member);
void set_RTC(void);

int main(void)
{
  //DS3231 rtc variables - default, use bit masks in ds3231.h for desired operation
    ds3231_cntl_stat_t rtc_control_status = {0,0}; 
    rtc.set_cntl_stat_reg(rtc_control_status);
    
    //******************************//
    ds3231_time_t time; 
    ds3231_calendar_t calendar; 
    
    set_RTC(); //Configuración del RTC
    
    while(1)
    {   
        rtc.get_time(&time);
        printf("Time %02d:%02d:%02d - RTC\n", time.hours, time.minutes, time.seconds);
        
        rtc.get_calendar(&calendar);
        printf("Calendar %02d/%02d/%02d\n",calendar.date, calendar.month, calendar.year);
        printf("\n");
        
        wait(1.0);
    }//loop 
}


/**********************************************************************
* Function: get_user_input() 
* Parameters: message - user prompt
*             min - minimum value of input
*             max - maximum value of input
*             member - pointer to struct member              
* Returns: none
*
* Description: get time/date input from user
*
**********************************************************************/
void get_user_input(char* message, uint8_t min, uint8_t max, uint32_t* member)
{
    uint32_t temp;

    do
    {
        printf("\n%s", message);
        
        //for some reason mbed doesn't like a pointer to a member in scanf
        //term.scanf("%d", member); works with gcc on RPi
        scanf("%d", &temp);
        
        *member = temp;
       
        if((*(member)< min) || (*(member) > max))
        {
            printf("\nERROR-RTI");
        }
    }
    while((*(member) < min) || (*(member) > max));
}


void get_user_input(char* message, uint8_t min, uint8_t max, bool* member)
{
    uint32_t temp;

    do
    {
        printf("\n%s", message);
        
        //for some reason mbed doesn't like a pointer to a member in scanf
        //term.scanf("%d", member); works with gcc on RPi
        scanf("%d", &temp);
        
        *member = temp;
       
        if((*(member)< min) || (*(member) > max))
        {
            printf("\nERROR-RTI");
        }
    }
    while((*(member) < min) || (*(member) > max));
}

/**********************************************************************/
void set_RTC(void){

//Cambio de la configuración del RTC DS3231
    ds3231_time_t rtc_time;
    ds3231_calendar_t rtc_calendar;
    
    //get day from user
    get_user_input("\nPlease enter day of week, 1 for Sunday (1-7): ", 1,
                    7, &rtc_calendar.day);

    //get day of month from user
    get_user_input("\nPlease enter day of month (1-31): ", 1, 31, 
                    &rtc_calendar.date);

    //get month from user
    get_user_input("\nPlease enter the month, 1 for January (1-12): ", 1, 
                    12, &rtc_calendar.month);

    //get year from user
    get_user_input("\nPlease enter the year (0-99): ",0, 99, 
                    &rtc_calendar.year);
      
    //Get time mode
    get_user_input("\nWhat time mode? 1 for 12hr 0 for 24hr: ", 0, 1, 
                   &rtc_time.mode);  
    
    if(rtc_time.mode)
    {
        //Get AM/PM status
        get_user_input("\nIs it AM or PM? 0 for AM 1 for PM: ", 0, 1, 
                       &rtc_time.am_pm);  
        //Get hour from user
        get_user_input("\nPlease enter the hour (1-12): ", 1, 12, 
                       &rtc_time.hours);
    }
    else
    {
        //Get hour from user
        get_user_input("\nPlease enter the hour (0-23): ", 0, 23, 
                       &rtc_time.hours);
    }
     
    //Get minutes from user
    get_user_input("\nPlease enter the minute (0-59): ", 0, 59, 
                   &rtc_time.minutes);
    
    
    //Get seconds from user
    get_user_input("\nPlease enter the second (0-59): ", 0, 59, 
                   &rtc_time.seconds);
    
    
    
    //Set the time, uses inverted logic for return value
    if(rtc.set_time(rtc_time))
    {
        printf("\nrtc.set_time failed!!\n");
        exit(0);
    }
    
    //Set the calendar, uses inverted logic for return value
    if(rtc.set_calendar(rtc_calendar))
    {
        printf("\nrtc.set_calendar failed!!\n");
        exit(0);
    }    
    
}


    