#include "mbed.h"
#include "EthernetInterface.h"
#include "DS2480B.h"

#define PORT   5001

#define searchROM 0xF0
#define alarmsearch 0xEC

#define ID 0x91000012E145EC01

DigitalOut toggle(p8);
DS2480B ds2480b;


Ticker flash;

int main (void) {

    ds2480b.Search(searchROM);

    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("\nServer IP Address is %s\n", eth.getIPAddress());
    
    UDPSocket server;
    server.init();
    server.set_broadcasting();
    
    Endpoint client;
    client.set_address("255.255.255.255", PORT);

    char str[256];  
    printf("Sending Packet back to Client\n");

        while (true) {
            
            ds2480b.Search(alarmsearch);
            int devices = ds2480b.Checkdevices();
            ds2480b.ConvertTemp();

            for(int i=ds2480b.ds1920first; i<ds2480b.ds1920no; i++){
                float temperature = ds2480b.AcquireTemp(ds2480b.romstorage[i]);
                sprintf(str, "%llX %f END", ds2480b.romstorage[i], ds2480b.temperature);
                printf("%s", str);
                server.sendTo(client, str, 256);
             }

            ds2480b.Search(searchROM);
            int devices = ds2480b.Checkdevices();

            ds2480b.ConvertTemp();

            for(int i=ds2480b.ds1990first; i<ds2480b.ds1990no; i++){
                if(ID == romstorage[i]){
                    for(int i=ds2480b.ds1920first; i<ds2480b.ds1920no; i++){
                        float temperature = ds2480b.AcquireTemp(ds2480b.romstorage[i]);
           
                        //send the temperature measurements
     
                        sprintf(str, "%llX %f END", ds2480b.romstorage[i], ds2480b.temperature);
                        printf("%s", str);
                        server.sendTo(client, str, 256);
                     }      
                }
            }
}
