#include "mbed.h"

class DS2480B {
    
    public:

    //master reset    
    void mreset(void);
    //reset 1-wire slaves       
    int reset(void);
    //send command that returns nothing
    void Mode(int command);
    //send command that expects a character to be received
    int Command(int command);
    //search accelerator
    void Search(int searchmode);
    //function obtaining the rom address from search accelerator data
    void getROM(void);
    //temperature conversion command sequence
    void ConvertTemp(void);
    //temperature acquisition command sequence
    float AcquireTemp(uint64_t address);
    // count devices and check for their type
    int Checkdevices(void); 
    
        
    int ds1920no;
    int ds1920first;
    int ds1990no;
    int ds1990first;
    uint64_t romstorage[2000];
    float temperature;
   
    private:
    
    int result;
    int temp;
    int byte;
    int mask;
    int hdb;
    int last_hdb;
    int ds1920ADD[128];
    int index;
    float scratchpad[9];
    int ROM[16];
    uint64_t rom;

};