#include "MicroBit.h"
#include "MicroBitUARTService.h"

MicroBit uBit;
MicroBitUARTService *uart;

uint16_t step_counter = 0;
bool in_range = false;
char stepsString[50];

int connected = 0;

MicroBitImage img("0 0 0 0 1\n0 0 0 0 1\n0 0 0 0 1\n0 0 0 0 1\n0 0 0 0 1\n");

//
// Scales the given value that is in the -1024 to 1024 range
// int a value between 0 and 4.
//
int pixel_from_g(int value)
{
    int x = 0;

    if (value > -750)
        x++;
    if (value > -250)
        x++;
    if (value > 250)
        x++;
    if (value > 750)
        x++;

    return x;
}

void onConnected(MicroBitEvent e)
{
    //uBit.display.scroll("C");

    connected = 1;

    while (connected == 1) {
        int x = pixel_from_g(uBit.accelerometer.getX());
        int y = pixel_from_g(uBit.accelerometer.getY());

        uBit.display.image.clear();
        uBit.display.image.setPixelValue(x, y, 255);
        //uBit.display.image.setPixelValue(1, 0, 255);
        if(y < 4) 
        {
            in_range = true;
            while(in_range)
            {
                y = pixel_from_g(uBit.accelerometer.getY());
                if(y == 4) 
                {
                    in_range = false;
                    step_counter ++;        
                }
            }
            sprintf(stepsString, "%d", step_counter);
            uart->send(stepsString);
                       
            uBit.serial.send("steps: ");                
            uBit.serial.send(step_counter);
            uBit.serial.send("\r\n");
            
        }        
        uBit.sleep(100);
    }

}
void onDisconnected(MicroBitEvent e)
{
    //uBit.display.scroll("D");
    connected = 0;
    step_counter = 0;
    
    
    
    while(connected == 0)
    {        
        uBit.display.scroll(img, 50, -1);
        uBit.display.scroll(img, 50, +1);
    }
}



int main()
{
    // Initialise the micro:bit runtime.
    uBit.init();
    uBit.serial.baud(115200);
    uBit.serial.send("Hello World\n");
    
    uBit.messageBus.listen(MICROBIT_ID_BLE, MICROBIT_BLE_EVT_CONNECTED, onConnected);
    uBit.messageBus.listen(MICROBIT_ID_BLE, MICROBIT_BLE_EVT_DISCONNECTED, onDisconnected);
    
    uart = new MicroBitUARTService(*uBit.ble, 32, 32);
    
    //uBit.display.scroll("Ready");
    

    //MicroBitImage i(heart_w,heart_h,heart); 
    //uBit.display.animate(i,10000,5);
    
    while(connected == 0)
    {        
        uBit.display.scroll(img, 50, -1);
        uBit.display.scroll(img, 50, +1);
    }
    
    release_fiber();

    //
    // Periodically read the accelerometer x and y values, and plot a 
    // scaled version of this ont the display. 
    //
    //while(1)
//    {
//        int x = pixel_from_g(uBit.accelerometer.getX());
//        int y = pixel_from_g(uBit.accelerometer.getY());
//
//        uBit.display.image.clear();
//        uBit.display.image.setPixelValue(x, y, 255);
//        //uBit.display.image.setPixelValue(1, 0, 255);
//        if(y < 4) 
//        {
//            in_range = true;
//            while(in_range)
//            {
//                y = pixel_from_g(uBit.accelerometer.getY());
//                if(y == 4) 
//                {
//                    in_range = false;
//                    step_counter ++;        
//                }
//            }
//            //y = pixel_from_g(uBit.accelerometer.getY());
//            //if(y == 4)             
//            uBit.serial.send("steps: ");                
//            uBit.serial.send(step_counter);
//            uBit.serial.send("\r\n");
//            
//        }            
//        
//        uBit.sleep(100);
//    }
}