#include "mbed.h"
#include "morse.h"

char* mcode[] =
{
    "a", "sl",
    "b", "lsss",
    "c", "lsls",
    "d", "lss",
    "e", "s",
    "f", "ssls",
    "g", "lls",
    "h", "ssss",
    "i", "ss",
    "j", "slll",
    "k", "lsl",
    "l", "slss",
    "m", "ll",
    "n", "ls",
    "o", "lll",
    "p", "slls",
    "q", "llsl",
    "r", "sls",
    "s", "sss",
    "t", "l",
    "u", "ssl",
    "v", "sssl",
    "w", "sll",
    "x", "lssl",
    "y", "lsll",
    "z", "llss",
    "1", "sllll",
    "2", "sslll",
    "3", "sssll",
    "4", "ssssl",
    "5", "sssss",
    "6", "lssss",
    "7", "llsss",
    "8", "lllss",
    "9", "lllls",
    "0", "lllll",
    ".", "slslsl",
    ",", "llssll",
    ":", "lllsss",
    "?", "ssllss",
    "\'", "slllls",
    "/", "lssls",
    "(", "lslls",
    ")", "lsllsl",
    "\"", "slssls",
    "-", "lssssl",
    "+", "slsls",
    "=", "lsssl",
    " ", "n",
    "*", "slsls",//end

    "≤","sl",
    "€","slsl",
    " ","lsss",
    "∆","lsls",
    "Œ","lss",
    "Õ","s",
    "ƒ","sslss",
    "¡","ssls",
    "ÿ","lls",
    "«","ssss",
    "Ÿ","lslls",
    "¶","slll",
    "‹","lsl",
    "∂","slss",
    "÷","ll",
    "¿","ls",
    "⁄","lll",
    "ø","llls",
    "¬","slls",
    "»","llsl",
    "≈","sls",
    "◊","sss",
    "—","l",
    "≥","ssl",
    "$","slssl",//Éê
    "…","ssll",
    "µ","slsss",
    "∏","sssl",
    "‘","sll",
    "œ","lssl",
    "π","lsll",
    "Ã","llss",
    "∫","llll",
    "¥","lslll",
    "√","slsll",
    "±","llsll",
    "ª","lslsl",
    "∑","lslss",
    "’","lssll",
    "“","lsssl",
    "–","sslsl",
    "º","llsls",
    "|","sllss",//Éë
    "À","llssl",
    "”","lssls",
    "æ","sllls",
    "Ω","lllsl",
    "›","slsls",
    "ﬁ","ss",
    "ﬂ","sslls",
    "∞","sllsl",//cho-on
    "•","slslsl",//kugiri-ten
    "#","slslss",//danraku
    "¢","lsllsl",//kakko
    "£","slssls",//kakko-toji
    "^","sssls",//shushin

    "\0", ""
};

int getcode(int c)
{
    for (int i = 0; mcode[i][0] != 0; i += 2) {
        if (mcode[i][0] == c) return i;
    }
    return -1;
}

void putbeep(const char* str, int freq, int step)
{
    //printf("%d:%s:%s\n", c, mcode[code], mcode[code + 1]);
    for (int i = 0; str[i] != '\0' && i < 1024; i++) {
        int c = getcode(str[i]);
        //printf("%c", mcode[c][0]);
        //put alphabet
        for (int k = 0; k < 10; ++k) {
            switch (mcode[c + 1][k]) {
            case 's':
                morsebeep(freq, step);
                morsewait(step);
                break;
            case 'l':
                morsebeep(freq, step * 3);
                morsewait(step);
                break;
            case 'n':
                morsewait(step * 6);
                break;
            case '_':
                morsewait(step * 2);
                break;
            case '\0':
                morsewait(step * 2);
                k = 10;
                break;
            }
        }
    }
}
