#include "mbed.h"
#include "TempDashSocketConnection.h"
#include "TemperatureSensor.h"
#include <string.h>

Serial pc(USBTX, USBRX); // tx, rx

std::string key = "c74d97b01eae257e44aa9d5bade97baf";
std::string name = "kristof";
static const char SERVER[] = "labict.be";
static const int PORT = 45678;

int main() {
    pc.baud(115200);
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    pc.printf("IP Address is %s\r\n", eth.getIPAddress());
    
    TemperatureSensor sensor(p28, p27, key, name);
    
    TempDashSocketConnection sock;
    
    while(1) {
        if (sensor.open()) {
            sock.connect(SERVER, PORT);
            sock.sendSensorData(sensor.getDataPacket());            
            sock.close();
            wait(1.0);
        }
    }
    eth.disconnect();
}
