/** COLOR CLASS
 */
#ifndef COLOR_H
#define COLOR_H

class Color{
  
    
  
   public:
        /** Create color instance
         *
         * @param red Value of red 0-255
         * @param green Value of green 0-255
         * @param blue Value of blue 0-255
         */
        Color(int red, int green, int blue);
        /** Create color instance
         *
         * @param color Hex or int value of a color
         */
        Color(int color);
        /** Create color instance
         *
         * @param red Value of red 0-1
         * @param green Value of green 0-1
         * @param blue Value of blue 0-1
         */
        Color(float red, float green, float blue);
        /** Returns the hex value of the color
         *
         * @param delay Print delay in milliseconds
         * @returns
         *   Hex value of the color
         */
        int getHex();
        /** Returns the red value of the color
         *
         * @param delay Print delay in milliseconds
         * @returns
         *  red value of the color
         */
        int getRed();
        /** Returns the green value of the color
         *
         * @param delay Print delay in milliseconds
         * @returns
         *  the red value of the color
         */
        int getGreen();
        /** Returns the blue value of the color
         *
         * @param delay Print delay in milliseconds
         * @returns
         *   the blue value of the color
         */
        int getBlue();
        enum colors{RED = 0xFF0000, 
                GREEN = 0x00FF00, 
                BLUE= 0x0000FF, 
                CYAN = 0x00FFFF, 
                MAGENTA = 0xFF00FF, 
                YELLOW = 0xFFFF00, 
                WHITE = 0xFFFFFF};
    
    private:
        static const int MAX_COLOR_VALUE = 255;
        int red;  
        int green; 
        int blue; 
        int floatToColorValue(float value);
        
};

#endif