
#include "RGB.h"

RGB::RGB(PinName r_pin, PinName g_pin, PinName b_pin){
  this->r_out = new PwmOut(r_pin);
  this->g_out = new PwmOut(g_pin);
  this->b_out = new PwmOut(b_pin);
}

float RGB::toFloat(int value){
    return (float) (255-value)/255;
};

void RGB::setColor(Color color){
     r_out->write(toFloat(color.getRed()));
     g_out->write(toFloat(color.getGreen()));
     b_out->write(toFloat(color.getBlue()));
}

void RGB::setColor(int red,int green,int blue){
        r_out->write(toFloat(red));
        g_out->write(toFloat(green));
        b_out->write(toFloat(blue));
}

void RGB::setColor(int color){
     Color kleur = Color(color);
     r_out->write(toFloat(kleur.getRed()));
     g_out->write(toFloat(kleur.getGreen()));
     b_out->write(toFloat(kleur.getBlue()));
            
}

void RGB::off(){
     r_out->write(0);
     g_out->write(0);
     b_out->write(0);            
}