
#include "Color.h"

Color::Color(int red, int green, int blue){
  this->red = red;
  this->green = green;
  this->blue = blue;
}

Color::Color(float red, float green, float blue){
  this->red = floatToColorValue(red);
  this->green = floatToColorValue(green);
  this->blue = floatToColorValue(blue);
}

Color::Color(int color){
  this->red = (color >> 16) & 0x0000FF;
  this->green = (color >> 8 ) & 0x0000FF;
  this->blue = (color >> 0 ) & 0x0000FF;
}

int Color::floatToColorValue(float value){
    return (int) (value * MAX_COLOR_VALUE);
};

int Color::getHex(){
    return (red << 16) + (green<<8) + (blue <<0);   
}

int Color::getRed(){
    return red;   
}

int Color::getGreen(){
    return green;   
}

int Color::getBlue(){
    return blue;   
}

