#ifndef IOController_H
#define IOController_H
#include <mbed.h>
#include "TemperatureSensor.h"
#include "Potentiometer.h"
#include "Joystick.h"
#include "Speaker.h"
#include "RGB.h"
#include "LCD.h"
#include "Communication.h"
#include "Packet.h"

/** IOController class
 *  Controls both the input(TemperatureSensor, Potentiometer, Joystick) and
 *  output(Speaker, RGB, LCD) devices. And uses the Communication class to send
 *  the read input data to an other client.
 *   @ref Joystick
 *   @ref TemperatureSensor
 *   @ref Potentiometer
 *   @ref Speaker
 *   @ref RGB
 *   @ref Potentiometer
 */

class IOController
{
public:

    /**
     *  Makes an instance of the IOController class, this will initialize 
     *  all the IO devices
     */
    IOController();
    
    /**
     *  Deletes the IOController and calls the destructor from
     *  all the IO devices
     */
    ~IOController();
    
    /**
     *  The main run method used in a loop for controlling the IO Devices
     */
    int run();

private:

    /**
     *  Pointer to an object of the class TemperatureSensor
     *
     *  @ref TemperatureSensor
     */
    TemperatureSensor * temperatureSensor;
    
    /**
     *  Pointer to an object of the class Potentiometer
     *
     *  @ref Potentiometer
     */
    Potentiometer * potentiometer;
    
    /**
     *  Pointer to an object of the class Joystick
     *
     *  @ref Joystick
     */
    Joystick * joystick;

    /**
     *  Pointer to an object of the class Speaker
     *
     *  @ref Speaker
     */
    Speaker * speaker;
    
    /**
     *  Pointer to an object of the class RGB
     *
     *  @ref RGB
     */
    RGB * rgbLed;
    
    /**
     *  Pointer to an object of the class LCD
     *
     *  @ref LDC
     */
    LCD * lcd;
    
    /**
     *  Pointer to an object of the class Communication
     *  @ref Communication
     */
    Communication * communication;
    
    /**
     *  Pointer to an object of the class Packet
     *
     *  @ref Packet
     */
    Packet * receivePacket;
    
    /**
     *  An integer resembling the ID of the destination
     */
    int destinationID;
    
    /**
     *  A boolean which is toggled on when the receiving is started.
     */
    bool startReceiving;
};

#endif