#include "IOController.h"

IOController::IOController()
{
    
    printf("-------------STARTING PROGRAM------------\r\n");
    printf("-----------------------------------------\r\n");
    
    //INPUT
    temperatureSensor = new TemperatureSensor(p28, p27);
    potentiometer = new Potentiometer(p19);
    joystick = new Joystick(p15,p12,p13,p16,p14);

    //OUTPUT
    speaker = new Speaker(p26);
    rgbLed = new RGB(p23,p24,p25);
    lcd = new LCD(p5, p7, p6, p8, p11);
    destinationID = 114;

    //ETHERNET
    //communication = new Communication();
    receivePacket = new Packet();
    /*
    std::vector<uint8_t> IDN;
    IDN.push_back(110);
    IDN.push_back(113);
    std::vector<int16_t> TMP;
    TMP.push_back(temperatureSensor->temp_short());
    TMP.push_back(temperatureSensor->temp_short());
    receivePacket = new Packet(2, 111, 240, IDN , TMP);
    printf("Packet 1 :'%s'\r\n",receivePacket->toDataString().c_str());
    receivePacket2 = new Packet();
    receivePacket2->dataInput(receivePacket->toDataString());
    printf("Packet 2 :'%s'\r\n",receivePacket2->toDataString().c_str());
    std::string str = receivePacket->toDataString();
    for (int i =0; i<str.size();i++){
        printf("char i: %c\r\n",str[i]);
        }
        float s =temperatureSensor->average(TMP);
    printf("average: %f",s);
    */
    startReceiving = false;
    rgbLed->off();
}

IOController::~IOController()
{
    delete temperatureSensor;
    delete potentiometer;
    delete joystick;
    delete speaker;
    delete rgbLed;
    delete lcd;
    delete receivePacket;
    delete communication;
}

int IOController::run()
{
    Joystick::Direction direction = joystick-> getDirection();//get direction input
    switch(direction) {
        case Joystick::UP: {
            lcd->cls();
            lcd->locate(0,3);
            lcd->printf("Receiving mode");
            communication = new Communication();
            communication->connect();
            startReceiving = true;
            break;
        }
        case Joystick::DOWN: {

            /*float temperature = temperatureSensor->read();
            lcd->cls();
            lcd->locate(0,3);
            lcd->printf("Temp = %.3f\n", temperature);
            */
            rgbLed->setRgbColor(potentiometer->readValue());
            std::string test;
            //12, 101, 1, 8, 230, 1, 105
            char ca[] = {0xAA,0x00,0xFF,0x55};
            
            for (int i = 0; i<sizeof(ca);i++){
                test.push_back(ca[i]);
            }
            char c = receivePacket->crc(test,0);
            lcd->cls();
            lcd->locate(0,3);
            lcd->printf("Dest. ID= %d\n", c);
            break;
        }

        case Joystick::RIGHT: {
            destinationID = (destinationID < 117) ?  destinationID+1 : destinationID;
            lcd->cls();
            lcd->locate(0,3);
            lcd->printf("Dest. ID= %d\n", destinationID);
            wait_ms(300);
            break;
        }

        case Joystick::LEFT: {
            destinationID = (destinationID > 100) ?  destinationID-1 : destinationID;
            lcd->cls();
            lcd->locate(0,3);
            lcd->printf("Dest ID= %d\n", destinationID);
            wait_ms(300);
            break;
        }
        case Joystick::MIDDLE: {
            communication = new Communication();
            communication->setOwnID(114);
            communication->connect();
            destinationID = 113;
            receivePacket->addValues(receivePacket->getNUM(),destinationID,potentiometer->readValue(), communication->getOwnID() ,temperatureSensor->temp_short());
            lcd->cls();
            lcd->locate(0,3);
            lcd->printf("Sending to  %d\n", destinationID);
            communication->sendDataPacket(receivePacket->toDataString());
            startReceiving = true;
            wait_ms(500);
            break;
        }
        default: {
            if(startReceiving) {
                std::string buf;
                //get data from other mbed
                buf = communication->getData();

                //info into Packet
                receivePacket->dataInput(buf);
                
                //Set color
                rgbLed->setRgbColor(receivePacket->getPWM());

                //Set speaker
                speaker->play(receivePacket->getNUM());

                //Average temperature on LCD
                lcd->cls();
                lcd->locate(0,3);
                float s =temperatureSensor->average(receivePacket->getTMP());
                lcd->printf("Average  %f\n", s);



                if (!receivePacket->idCheck(communication->getOwnID()) || !receivePacket->crcCheck()){
                    lcd->printf("GAME OVER\n", s);
                    return -1;
                }
                //change packet to data
                receivePacket->addValues(receivePacket->getNUM(),destinationID,potentiometer->readValue(), communication->getOwnID() ,temperatureSensor->temp_short());

                //sending data to next
                communication->sendDataPacket(receivePacket->toDataString());
                wait_ms(110);
                break;

            }
        }
    }
    return 1;
}