
#ifndef COLOR_H
#define COLOR_H
/** Color class.
 *  Used in te RGB class to easily set colors. Colors can be created by inserting the HEX/integer value of the color.
 *  Or by inserting the float or int value from each color (red, green, blue)
 */
class Color
{
public:

    /** Create color instance by inserting the 0-255 value for each rgb color
     *
     * @param red Value of red 0-255
     * @param green Value of green 0-255
     * @param blue Value of blue 0-255
     */
    Color(int red, int green, int blue);

    /** Create color instance by inserting the hex or int value of the color
     *
     * @param color Hex or int value of a color
     */
    Color(int color);

    /** Create color instance with a float for each color
     *
     * @param red Value of red 0-1
     * @param green Value of green 0-1
     * @param blue Value of blue 0-1
     */
    Color(float red, float green, float blue);

    /** Returns the hex value of the color
     *
     * @return Hex value of the color
     */
    int getHex();

    /** Returns the red value of the color
     *
     * @return red value of the color
     */
    int getRed();

    /** Returns the green value of the color
     *
     * @return the red value of the color
     */
    int getGreen();

    /** Returns the blue value of the color
     *
     * @return the blue value of the color
     */
    int getBlue();

    /** Enum with different kind of preset colors to use
    */
    enum colors {RED = 0xFF0000,
                 GREEN = 0x00FF00,
                 BLUE= 0x0000FF,
                 CYAN = 0x00FFFF,
                 MAGENTA = 0xFF00FF,
                 YELLOW = 0xFFFF00,
                 WHITE = 0xFFFFFF
                };

private:
    static const int MAX_COLOR_VALUE = 255;
    int red, green, blue;
    int floatToColorValue(float value);

};

#endif