#ifndef TemperatureSensor_H
#define TemperatureSensor_H
#include "LM75B.h"
#include <mbed.h>
#include <string>
#include <vector>


/** Temperature class.
 *  Utilised to read the 
 *  with the help of a TCPSocketServer, but also to send packets to other clients
 *  with a TCPSocketConnection
 *  @ref LM75B
 */
class TemperatureSensor : public LM75B
{
public:

    /** Create an Temperature Sensor object (using the default ADDRESS_0)
     * connected to the specified I2C pins with the specified I2C slave address 
     *
     * @param sda The I2C data pin.
     * @param scl The I2C clock pin.
     */
    TemperatureSensor(PinName sca, PinName scl);
    
    /** Convert 11 bit sign extended value (int16_t) to a float in °C
     *
     * @param value temperature expressed as 11 bit sign extended values of type int16_t
     * @returns the temperature in °C
     */
    float shortToFloat(int16_t value);
    
    /** Get the current temperature measurement of the TemperatureSensor
     *
     * @returns The current temperature measurement as 11 bit extended sign value
     */
    int16_t temp_short(void);
    
    /** Get the average temperature of a vector of 11 bit sign extended values
     *
     * @param TMP and std::vector of temperatures expressed as 11 bit sign extended values of type int16_t
     * @returns the average temperature in °C
     */
    float average(std::vector<int16_t> TMP);
    
private:
    PinName sca;
    PinName scl;
};

#endif