
#include "RGB.h"

RGB::RGB(PinName r_pin, PinName g_pin, PinName b_pin)
{
    this->r_out = new PwmOut(r_pin);
    this->g_out = new PwmOut(g_pin);
    this->b_out = new PwmOut(b_pin);
}

RGB::~RGB()
{
    delete r_out;
    delete g_out;
    delete b_out;
    delete color;
}

float RGB::toFloat(int value)
{
    return (float) (255-value)/255;
};

void RGB::setColor(Color color)
{
    r_out->write(toFloat(color.getRed()));
    g_out->write(toFloat(color.getGreen()));
    b_out->write(toFloat(color.getBlue()));
    this->color = &color;
}

void RGB::setColor(int red,int green,int blue)
{
    r_out->write(toFloat(red));
    g_out->write(toFloat(green));
    b_out->write(toFloat(blue));
    this->color = new Color(red,green,blue);
}

void RGB::setColor(int color)
{
    Color * kleur = new Color(color);
    r_out->write(toFloat(kleur->getRed()));
    g_out->write(toFloat(kleur->getGreen()));
    b_out->write(toFloat(kleur->getBlue()));
    this->color = kleur;
}
void RGB::setRgbColor(int WheelPos)
{
    if(WheelPos < 85) {
        RGB::setColor(255 - WheelPos * 3, 0, WheelPos * 3);
    } else if(WheelPos < 170) {
        WheelPos -= 85;
        RGB::setColor(0, WheelPos * 3, 255 - WheelPos * 3);
    } else {
        WheelPos -= 170;
        RGB::setColor(WheelPos * 3, 255 - WheelPos * 3, 0);
    }
}



void RGB::off()
{
    r_out->write(1);
    g_out->write(1);
    b_out->write(1);
}