#ifndef Communication_H
#define Communication_H
#include <mbed.h>
#include <string>
#include "Packet.h"

#include "EthernetInterface.h"

#define FRAME_BYTE_1 0xAA
#define FRAME_BYTE_2 0x55
#define SERVER_PORT   4000

//const char * address = "192.168.0.114";
//const char * mask = "255.255.255.0";
//const char * gateway = "192.168.0.1";

/** Communication class.
 *  Utilised to make use of the EthernetInterface to receive packets
 *  with the help of a TCPSocketServer, but also to send packets to other clients
 *  with a TCPSocketConnection
 *  @ref TCPSocketConnection
 *  @ref TCPSocketServer
 *  @ref EthernetInterface
 */
class Communication{ 
 public: 
   
    /** Default Constructor
    *   Creates an object of the Communication class, which 
    *   will automaticly connect to the EthernetInterface.
    * 
    *   @ref EthernetInterface
    */
    Communication();
         
    /** Destructor 
    *   Destroys all the objects using memory with this class
    *   and disconnects the connections made by the class.
    */
    ~Communication();
    
    /** Connects to internet with the help of the EthernetInterface
    *   and manualy sets the ip address, it also generates a TCPSocketServer
    *   to be able to receive data.
    *
    *   @ref EthernetInterface
    *   @ref TCPSocketServer
    */
    void connect();
    
    /** Creates a TCPSocketConnection "client" to receive a Packet from a client
    *   by accepting it with the TCPSocketServer "server"
    *   @param buffer The reference to a std::string buffer that has to be 
    *   filled with the received data Packet.
    *
    *   @ref Packet
    *   @ref TCPSocketServer
    *   @ref TCPSocketConnection
    */
   std::string getData();
    
    /** Uses the TCPSocketServer "server" to receive a Packet from a client
    *
    *   @param data the string from a packet that contains the data that has to be sent to
    *   a client.
    *
    *   @ref Packet
    *   @ref TCPSocketServer
    */
    void sendDataPacket(std::string data);
    
    /** 
    *   Sets the ID where the MBED has to connect to
    *
    */
    void setOwnID(int i);

    int getOwnID();
  
 private:
 
    /**
    *   An instance of the TCPSocketServer to be able to receive data.
    *
    *   @ref TCPSocketServer
    */
    TCPSocketServer * server;
    
    /**
    *   An instance of the EthernetInterface class that will make it possible 
    *   to connect to the internet.
    *
    *   @ref EthernetInterface
    */
    EthernetInterface * eth;    
    int ownID;
};

#endif