#include "Communication.h"

Communication::Communication()
{

    this->ownID = 113;
    eth = new EthernetInterface();
    printf("Ethernet initialized\r\n");
}

Communication::~Communication()
{
    delete eth;
    delete server;
}


void Communication::connect()
{
    //printf("Initiating Ethernet\r\n");
    //eth->init();
    char IPAddr[512];
    sprintf(IPAddr,"192.168.0.%d",ownID);
    eth->init(IPAddr, "255.255.255.0", "192.168.0.1"); //Use DHCP
    //eth->init("10.182.34.113", "255.255.255.0", "10.182.34.1"); //Use DHCP
    printf("Connecting Ethernet\r\n");
    eth->connect();
    //printf("Server IP Address is %s\r\n", eth->getIPAddress());
    server = new TCPSocketServer();
    //printf("Binding server port\r\n");
    server->bind(SERVER_PORT);
    //printf("Listen to port\r\n");
    server->listen();
}

void Communication::sendDataPacket(std::string data)
{
    printf("-------------SENDING------------\r\n");
    char IPAddr[512];
    char buffer[512];
    //strcpy(buffer, data.c_str());
    //data.copy(buffer,0,data.size());
    printf("Sending data chars:\r\n");
  
    printf("DATA: ");
    for (int a = 0; a<data.size(); a++) {
        buffer[a] = data.at(a);
        printf("%d ",buffer[a]);
    }
    printf("\r\n");
    TCPSocketConnection client;
    //server->accept(client);
    //sprintf(buf,"10.182.34.%d",packet.getIDD());
    sprintf(IPAddr,"192.168.0.%d",data[3]);
    while (client.connect(IPAddr, SERVER_PORT) < 0) {
        printf("Unable to connect to (%s) on port (%d)\r\n", IPAddr, SERVER_PORT);
        wait(1);
    }
    client.send_all(buffer, data.size());

    client.close();

}

std::string Communication::getData()
{
     printf("-------------RECEIVING------------\r\n");
    //printf("Wait for new connection...\r\n");
    TCPSocketConnection client;
    std::string str;
    server->accept(client);
    client.set_blocking(false, 5000); // Timeout after (1.5)s
    //printf("Connection from: %s\r\n", client.get_address());
    char buffer[512];
    while (true) {
        int n = client.receive_all(buffer, 512);

        //printf("size :'%d'\r\n",n);
        if (n <= 0) break;

        // print received message to terminal
        buffer[n] = '\0';
        //printf("Received message from Client :'%s'\r\n",buf);


        //str = buffer;
        printf("Received data:\r\n");
        for (int a = 0; a<n; a++) {
            if (buffer[a] == 0){
                str.push_back('\0');
            }else{
                str.push_back(buffer[a]);
            }
            printf("%d : %d",str.at(a), buffer[a]);
        }
        printf("\r\n");
        if (n <= 0) break;
    }
    client.close();
    return str;

}

void Communication::setOwnID(int i)
{
    this->ownID = i;
}

int Communication::getOwnID()
{
    return this->ownID;
}

/* 
void Communication::sendDataTest(int8_t IDD)
{
    TCPSocketConnection client;
    //server->accept(client);
    char buf[13];
    //sprintf(buf,"10.182.34.%d",IDD);
    sprintf(buf,"192.168.0.%d",IDD);
    while (client.connect(buf, SERVER_PORT) < 0) {
        printf("Unable to connect to (%s) on port (%d)\n", buf, SERVER_PORT);
        wait(1);
    }
    char str[512] = "THIS IS A TEST";
    client.send_all(str, sizeof(str) - 1);
    client.close();
}

void Communication::sendData(int8_t NUM, int8_t IDD, int8_t PWM, int8_t IDN[] , int16_t TMP[] ){
        TCPSocketConnection client;
        //server->accept(client);
        char buf[13];
        sprintf(buf,"192.168.0.%d",IDD);
        while (client.connect(buf, SERVER_PORT) < 0) {
            printf("Unable to connect to (%s) on port (%d)\r\n", buf, SERVER_PORT);
            wait(1);
        }
        printf("Connected to Server at %s\n",buf);
        char str[512];
        str[0] = FRAME_BYTE_1;
        str[1] = FRAME_BYTE_2;
        str[2] = NUM;
        str[3] = IDD;
        str[4] = PWM;

        int frameNumber = 5;
        for( int i = 0; i < IDN.size(); i++ ) {
            str[frameNumber] = IDN[i];
            frameNumber++;
        }
        for( int i = 0; i < TMP.size(); i++ ) {
            int16_t data = TMP[i];
            for(int i = 0; i < 2; i++)
            {
                str[frameNumber] = data & 0xff;
                data >>= 8;
                frameNumber++;
            }
        }
        str[frameNumber] = FRAME_BYTE_2;
        str[frameNumber+1] = FRAME_BYTE_1;

        client.send_all(str, sizeof(str) - 1);
        client.close();


}*/
