#ifndef Joystick_H
#define Joystick_H

#include "mbed.h"
//Class to control an RGB LED using three PWM pins
class Joystick
{

public:

    /**
     * Represents the possible directions of the joystick
     */
    enum Direction { 
        UP, 
        DOWN, 
        LEFT, 
        RIGHT, 
        MIDDLE, 
        NONE 
    };
    
    /** Creates an object of a joystick which can be used to control 
     *
     * @param up
     * @param down
     * @param right
     * @param right
     * @param middle
     * @returns the average temperature in °C
     */
    Joystick(PinName up, PinName down, PinName left, PinName right, PinName middle);
    
    /**
     * The destructor of the Joystick destroying all the DigitalIn objects
     */
    ~Joystick();
    
    /**
     * Gets the direction the joystick is pressed 
     *
     * @return the direction of the joystick
     */
    Direction getDirection();
    
private:
    DigitalIn * up;
    DigitalIn * down;
    DigitalIn * left;
    DigitalIn * right;
    DigitalIn * middle;
    Direction direction;
};

#endif