#include "Joystick.h"

Joystick::Joystick(PinName up, PinName down, PinName left, PinName right, PinName middle)
{
    this->up = new DigitalIn(up);
    this->down = new DigitalIn(down);
    this->left = new DigitalIn(left);
    this->right = new DigitalIn(right);
    this->middle = new DigitalIn(middle);
}
Joystick::~Joystick()
{
    delete up;
    delete down;
    delete left;
    delete right;
    delete middle;
}

Joystick::Direction Joystick::getDirection()
{
    //printf("%d %d %d %d %d \n",up->read(),down->read(),left->read(),right->read(),middle->read());
    if (up->read() == 1) {
        direction = UP;
    } else if(down->read() == 1) {
        direction = DOWN;
    } else if(left->read() == 1) {
        direction =  LEFT;
    } else if(right->read() == 1) {
        direction =  RIGHT;
    } else if(middle->read() == 1) {
        direction = MIDDLE;
    } else {
        direction = NONE;
    }
    return direction;
}