#include "TemperatureSensor.h"
#include "LM75B.h"
#include <mbed.h>
#include <string>


TemperatureSensor::TemperatureSensor(PinName sca, PinName scl)
    :LM75B(sca,scl)
{
    this->sca = sca;
    this->scl = scl;
}

int16_t TemperatureSensor::temp_short(void)
{
    //Signed return value
    int16_t value;

    //Read the 11-bit raw temperature value
    value = this->read16(0x00) >> 5;

    //Sign extend negative numbers
    if (value & (1 << 10))
        value |= 0xFC00;

    //Return the temperature in °C
    return value;
}

float TemperatureSensor::shortToFloat(int16_t value)
{
    return value*0.125;
}

float TemperatureSensor::average(std::vector<int16_t> TMP)
{
    printf("test \r\n");
    float sum = 0;
    for( int i = 0; i < TMP.size(); i++ ) {
        float data = TemperatureSensor::shortToFloat(TMP.at(i));
        sum +=data;
    }
    printf("Temperature average %f \r\n",(float) sum /TMP.size());
    return ((float)sum) /TMP.size();
}