#include "Speaker.h"


float Speaker::soundValues[17][3] = {
    {110, 480, 100} ,//1
    {110, 480, 100} ,//2
    {110, 480, 100} ,//3
    {98, 360, 75} ,//4
    {130, 120, 100} ,//5
    {110, 480, 100} ,//6
    {98, 360, 75} ,//7
    {130, 120, 100} ,//8
    {110, 960, 100} ,//9
    {165, 480, 100} ,//10
    {165, 480, 100} ,//11
    {165, 480, 100} ,//12
    {175, 360, 75} ,//13
    {130, 120, 100} ,//14
    {104, 480, 100} ,//15
    {98, 360, 75} ,//16
    {130, 120, 100} //17
};

Speaker::Speaker(PinName pin) :PwmOut(pin)
{

}

Speaker::~Speaker()
{
    delete this;
}

void Speaker::play(int number)
{
    float freq = 0;
    float duration = 0;
    float delay = 0;
    for (int i = 1; i < number; i++) {
        freq =  soundValues[i-1][0];
        duration = soundValues[i-1][1];
        delay = soundValues[i-1][2];
        playSound(freq ,duration, delay);
    }
}

void Speaker::playSound(float frequency, float duration, float delay)
{
    this->period(1.0/frequency);
    this->write(0.5);
    wait_ms(duration);
    this->write(0.0);
    this->period(0.0005);
    wait_ms(delay);
}
