#ifndef RGB_H
#define RGB_H
#include <mbed.h>
#include <Color.h>

/** RGB class
 *  Uses PWM modulation on each pin to control every color on a RGB led.
 */

class RGB
{

public:

    /** Creates an instance of RGB
     * @param r_pin the PinName of r_pin
     * @param g_pin the PinName of g_pin
     * @param b_pin the PinName of b_pin
     */
    RGB(PinName r_pin, PinName g_pin, PinName b_pin);

    /** Destructor from the RGB
    */
    ~RGB();
    /** Sets the color by giving a color from the Color class
     * @param color sets the color to this instance of the class Color
     * @ref Color
     */
    void setColor(Color color);

    /** Sets the color by setting a value (0-255) for each pin
     *
     * @param red Set the red value of the color 0-255
     * @param green Set the green value of the color 0-255
     * @param blue Set the blue value of the color 0-255
     */
    void setColor(int red, int green, int blue);

    /** Sets the color by giving a hexadecimal value of the color
     * @param color the hex value of the color u want to set
     */
    void setColor(int color);

    /** Sets the color by giving a hexadecimal value of the color
     * @param color the hex value of the color u want to set
     */
    void setRgbColor(int color);

    /** Gets the Color of the led
     *
     * @return the color
     * @ref Color
     */
    Color* getColor();

    /** Turns the led off
     *
     */
    void off();


private:
    float toFloat(int value);
    PinName r_pin, g_pin, b_pin;
    PwmOut* r_out;
    PwmOut* g_out;
    PwmOut* b_out;
    Color* color;
};

#endif