#include "Transmitter.h"

RF24 radio(spi_MOSI, spi_MISO, spi_SCK, nrf_CE, nrf_CSN );
RF24Network network(radio);
unsigned long packets_sent;
RF24NetworkHeader header_rx;
char previous_char;

/**
    Constructor: Initialize RF24 and RF24Network
*/
Verzender::Verzender()
{
    wait_ms(2000);
    radio.begin();
    network.begin(90, this_node);
    wait_ms(2000);
    radio.setPALevel(RF24_PA_MIN);
    radio.setDataRate(RF24_250KBPS);
    
}

void Verzender::update()
{
    network.update();
}

bool Verzender::write(payload_t packet)
{
    RF24NetworkHeader header_tx(other_node);
    payload_t payload_tx;
    payload_tx = packet;
    
    payload_tx.messageIndex = 0;
    payload_tx.messageAvailable = false;
    
    return network.write(header_tx,&payload_tx,sizeof(payload_tx));
}

void Verzender::sendMessage(char index){
        
        if(previous_char != index){
        RF24NetworkHeader header_tx(other_node);
        payload_t payload_message;
        payload_message.messageIndex = index;
        payload_message.messageAvailable = true;
        bool test = network.write(header_tx,&payload_message,sizeof(payload_message));
        }
        previous_char = index;
    }

state_Packet Verzender::read()
{
    state_Packet packet;
    network.read(header_rx,&packet,sizeof(packet));
    
    return packet;
}

bool Verzender::available()
{
    return network.available();
}

void Verzender::printDetails(){
    radio.printDetails();
    }