#include "mbed.h"

Serial pc(USBTX, USBRX);

// Read the voltage
AnalogIn ain(A2);

/*I2C
I2C i2c(D4, D5);
//Slave address
//char SLAVE_ADDRESS = 0b11110000; // 7 bits => 0b1111000 = 0x78


char * i2cRead(){
     char data[2];
     i2c.read(SLAVE_ADDRESS, data, 2);
     pc.printf("%s\r\n",data);
     return data;
}
*/



float TARE_VALUE = 0 ;
float CALIBRATION_VALUE = 0 ;
int CALIBRATION_MASS = 1131;
int SAMPLE_AMOUNT = 2000;


float analogRead()
{
    float beginval = 0;
     for(int i = 0; i < 100; i++) {
        beginval += ain.read();

    } 
    float gemiddeld = beginval/100;
    pc.printf("Gemiddelde %f\r\n", gemiddeld);
    
    
    float curval = 0;
    int del = 0 ;
    for(int i = 0; i < SAMPLE_AMOUNT; i++) {
        if ( ain.read()< gemiddeld +0.001012*2 && ain.read()> gemiddeld -0.001012*2){            
            curval += ain.read();
        }else {
            del ++;
            
        }

    }
        pc.printf("Deleted %d\r\n", del);

    return (curval + beginval) /(SAMPLE_AMOUNT-del + 100);
}

float calculateMass(float value)
{
    return ((TARE_VALUE - value)*(CALIBRATION_MASS))/(TARE_VALUE - CALIBRATION_VALUE);
}

void log(char c[])
{
    pc.printf("%s\r\n", c);
}

void tare()
{
    TARE_VALUE = analogRead();
    pc.printf("Tare %f\r\n", TARE_VALUE);
}

void init()
{
    pc.printf("### INITIALISING ###\r\n");
    tare();
    pc.printf("### INIT COMPLETE ###\r\n");
}


int main()
{
    init();
    while (1) {
        if(pc.readable()) {
            switch (pc.getc()) {
                case 't':
                    tare();
                    break;
                case 'c':
                    CALIBRATION_VALUE = analogRead();
                    pc.printf("Callibrate %f\r\n", CALIBRATION_VALUE);

                    break;
                case 'y':
                    float mass = calculateMass(analogRead());
                    pc.printf("MASS %f\r\n", mass);

                    break;

            };

        }
        wait_ms(500);


    }
    return 0;
}


